% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotGLME.R
\name{sjp.lmer}
\alias{sjp.lmer}
\title{Plot estimates (forest plots) of linear mixed effects models}
\usage{
sjp.lmer(fit, type = "re", vars = NULL, ri.nr = NULL, emph.grp = NULL,
  title = NULL, geom.size = 3, geom.colors = "Set1",
  hideErrorBars = FALSE, showIntercept = TRUE,
  stringIntercept = "(Intercept)", sort.coef = NULL, pred.labels = NULL,
  axisTitle.x = NULL, axisTitle.y = NULL, interceptLineType = 2,
  interceptLineColor = "grey70", showValueLabels = TRUE, labelDigits = 2,
  showPValueLabels = TRUE, facet.grid = TRUE, free.scale = FALSE,
  fade.ns = FALSE, printPlot = TRUE)
}
\arguments{
\item{fit}{a fitted \code{lmer} object.}

\item{type}{type of plot. Use one of following:
\itemize{
  \item \code{"re"} (default) for estimates of random effects
  \item \code{"fe"} for estimates of fixed effects
  \item \code{"fe.std"} for standardized estimates of fixed effects
  \item \code{"fe.pred"} for regression lines (slopes) with confidence intervals for each single fixed effect are plotted, i.e. all fixed effects are extracted and each is plotted against the response variable.
  \item \code{"fe.cor"} for correlation matrix of fixed effects
  \item \code{"re.qq"} for a QQ-plot of random effects (random effects quantiles against standard normal quantiles)
  \item \code{"fe.ri"} for fixed effects slopes depending on the random intercept.
}}

\item{vars}{a numeric vector with column indices of selected variables or a character vector with
variable names of selected variables from the fitted model, which should be used to plot
fixed effects slopes for random intercept. This parameter only applies if \code{type = "fe.ri"}.
In this case, only slopes for the selected variables specified in \code{"vars"} will be plotted.}

\item{ri.nr}{Numeric vector. If \code{type = "re"} or \code{type = "fe.ri"}, and fitted model has more than one random
intercept, \code{ri.nr} indicates which random effects of which random intercept (or:
which list elements of \code{lme4::ranef}) will be plotted. Default is \code{NULL},
so all random effects will be plotted.}

\item{emph.grp}{numeric vector with index numbers of grouping levels (from random effect).
If \code{type = "fe.ri"} and \code{facet.grid = FALSE}, an integrated plot of fixed
effects slopes for each grouping level is plotted. To better find
certain groups, use this parameter to emphasize these groups in the plot.
See examples for details.}

\item{title}{a character vector with one or more labels that are used as plot title. If
\code{type = "re"}, use the predictors' variable labels as titles.}

\item{geom.size}{size of geoms (point size).}

\item{geom.colors}{User defined color palette for geoms. Must either be vector with two color values
or a specific color palette code (see below).
\itemize{
  \item If not specified, the diverging \code{"Set1"} color brewer palette will be used.
  \item If \code{"gs"}, a greyscale will be used.
  \item If \code{geom.colors} is any valid color brewer palette name, the related \href{http://colorbrewer2.org}{color brewer} palette will be used. Use \code{display.brewer.all()} from the \code{RColorBrewer} package to view all available palette names.
}
Else specify your own color values as vector (e.g. \code{geom.colors=c("#f00000", "#00ff00")}).}

\item{hideErrorBars}{If \code{TRUE}, the error bars that indicate the confidence intervals of the estimates are not
shown.}

\item{showIntercept}{if \code{TRUE}, the intercept is included when plotting random or fixed effects.}

\item{stringIntercept}{string of intercept estimate on the y axis. Only applies, if \code{showIntercept}
is \code{TRUE} and \code{pred.labels} is not \code{NULL}.}

\item{sort.coef}{indicates which coefficient should be used for sorting estimates.
\itemize{
  \item If \code{NULL} (default), no sorting is done and estimates are sorted in order of model coefficients.
  \item If \code{sort.coef = "sort.all"}, estimates are re-sorted for each coefficient (only applies if \code{type = "re"} and \code{facet.grid = FALSE}), i.e. the estimates of the random effects for each predictor are sorted and plotted to an own plot.
  \item If \code{type = "fe"} or \code{type = "fe.std"}, \code{TRUE} value will sort the estimates.
  \item Else, specify a predictor's / coefficient's name to sort estimators according to this coefficient.
  }
  See examples for details.}

\item{pred.labels}{a character vector with labels for the predictors / covariates / groups. Should either be vector
of fixed effects variable labels (if \code{type = "fe"} or \code{type = "fe.std"}) or a vector of group (value)
labels from the random intercept's categories (if \code{type = "re"}).}

\item{axisTitle.x}{A label (title) for the x axis. If not specified, a default labelling depending
on the plot type is chosen.}

\item{axisTitle.y}{A label (title) for the y axis. If not specified, a default labelling depending
on the plot type is chosen.}

\item{interceptLineType}{The linetype of the intercept line (zero point). Default is \code{2} (dashed line).}

\item{interceptLineColor}{The color of the intercept line. Default value is \code{"grey70"}.}

\item{showValueLabels}{Whether the beta and standardized beta values should be plotted
to each dot or not.}

\item{labelDigits}{The amount of digits for rounding the estimations (see \code{showValueLabels}).
Default is 2, i.e. estimators have 2 digits after decimal point.}

\item{showPValueLabels}{Whether the significance levels of each coefficient should be appended
to values or not}

\item{facet.grid}{\code{TRUE} when each plot should be plotted separately instead of
an integrated (faceted) single graph.}

\item{free.scale}{If \code{TRUE} and \code{facet.grid=TRUE}, each facet grid gets its own fitted scale. If
\code{free.scale=FALSE}, each facet in the grid has the same scale range.}

\item{fade.ns}{if \code{TRUE}, non significant estimates will be printed in slightly fading colors.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns
         \itemize{
           \item the ggplot-object (\code{plot}), if \code{type = "fe"} or if \code{type = "re"} and \code{facet.grid = TRUE}). Multiple plots (\code{type = "re"} and if \code{facet.grid = FALSE}) are returned in the object \code{plot.list}.
           \item a list of ggplot-objects (\code{plot.list}). see \code{plot} for details.
           \item a data frame \code{mydf} with the data used to build the ggplot-object(s).
           }
}
\description{
Plot estimates (coefficients) with confidence intervalls of either
               fixed effects or random effects of linear mixed effects models
               (that have been fitted with \code{lmer} of the
               \code{lme4} package.
}
\examples{
\dontrun{
# fit model
library(lme4)
library(sjmisc)
fit <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

# simple plot
sjp.lmer(fit)

# plot fixed effects
sjp.lmer(fit, type = "fe")

# sort by predictor Days
sjp.lmer(fit, sort.coef = "Days")

# plot each predictor as own plot
# sort each plot
sjp.lmer(fit,
         facet.grid = FALSE,
         sort.coef = "sort.all")

# plot and sort fixed effects
sjp.lmer(fit,
         type = "fe",
         sort.coef = TRUE)


library(lme4)
library(sjmisc)
data(efc)
# prepare group variable
efc$grp = as.factor(efc$e15relat)
levels(x = efc$grp) <- get_val_labels(efc$e15relat)
# data frame for fitted model
mydf <- na.omit(data.frame(neg_c_7 = as.numeric(efc$neg_c_7),
                           sex = as.factor(efc$c161sex),
                           c12hour = as.numeric(efc$c12hour),
                           barthel = as.numeric(efc$barthtot),
                           grp = efc$grp))
# fit glmer
fit <- lmer(neg_c_7 ~ sex + c12hour + barthel + (1|grp),
            data = mydf)

# plot random effects
sjp.lmer(fit)

# plot fixed effects
sjp.lmer(fit, type = "fe")

sjp.lmer(fit,
         type = "fe.std",
         sort.coef = TRUE)

# plot fixed effects slopes for
# each random intercept, but only for
# coefficient "c12hour"
sjp.lmer(fit,
         type = "fe.ri",
         vars = "c12hour")

# highlight specific grouping levels
# in this case we compare spouses, children
# and children-in-law
sjp.lmer(fit,
         type = "fe.ri",
         emph.grp = c(1, 2, 4),
         vars = "c12hour")

# plot fixed effects correlations
sjp.lmer(fit, type = "fe.cor")

# qq-plot of random effects
sjp.lmer(fit, type = "re.qq")}
}
\seealso{
\href{http://www.strengejacke.de/sjPlot/sjp.lmer/}{sjPlot manual: sjp.lmer}
}

