% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{plotInternalStructure}
\alias{plotInternalStructure}
\title{Plot internal metacommunity structure}
\usage{
plotInternalStructure(
  object,
  Rsquared = c("McFadden", "Nagelkerke"),
  add_shared = TRUE,
  env_deviance = NULL,
  suppress_plotting = FALSE
)
}
\arguments{
\item{object}{anova object from \code{\link{anova.sjSDM}}}

\item{Rsquared}{which R squared should be used, McFadden or Nagelkerke (McFadden is default)}

\item{add_shared}{split shared components, default is TRUE}

\item{env_deviance}{environmental deviance}

\item{suppress_plotting}{should the plots be suppressed or not.

Plots and returns the internal metacommunity structure of species and sites (see Leibold et al., 2022). 
Plots were heavily inspired by Leibold et al., 2022}
}
\value{
List with the following components:


\item{plots}{ggplot objects for sites and species.}
\item{data}{List of data.frames with the internal metacommunity structure.}
}
\description{
Plot internal metacommunity structure
}
\references{
Leibold, M. A., Rudolph, F. J., Blanchet, F. G., De Meester, L., Gravel, D., Hartig, F., ... & Chase, J. M. (2022). The internal structure of metacommunities. Oikos, 2022(1).
}
