% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_label.R
\name{as_label}
\alias{as_label}
\title{Convert variable into factor with associated value labels}
\usage{
as_label(x, ..., add.non.labelled = FALSE, prefix = FALSE,
  var.label = NULL, drop.na = TRUE, drop.levels = FALSE)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or dplyr's \code{\link[dplyr]{select_helpers}}.
See 'Examples'.}

\item{add.non.labelled}{Logical, if \code{TRUE}, values without associated
value label will also be converted to labels (as is). See 'Examples'.}

\item{prefix}{Logical, if \code{TRUE}, the value labels used as factor levels
or character values will be prefixed with their associated values. See 'Examples'.}

\item{var.label}{Optional string, to set variable label attribute for the
returned variable (see vignette \href{../doc/intro_sjlabelled.html}{Labelled Data and the sjlabelled-Package}).
If \code{NULL} (default), variable label attribute of \code{x} will
be used (if present). If empty, variable label attributes will be removed.}

\item{drop.na}{Logical, if \code{TRUE}, tagged \code{NA} values with value labels
will be converted to regular NA's. Else, tagged \code{NA} values will be replaced
with their value labels. See 'Examples' and \code{\link{get_na}}.}

\item{drop.levels}{Logical, if \code{TRUE}, unused factor levels will be
dropped (i.e. \code{\link{droplevels}} will be applied before returning
the result).}
}
\value{
A factor with the associated value labels as factor levels. If \code{x}
          is a data frame, the complete data frame \code{x} will be returned,
          where variables specified in \code{...} are coerced to factors;
          if \code{...} is not specified, applies to all variables in the
          data frame.
}
\description{
This function converts (replaces) values of a variable (also of factors
               or character vectors) with their associated value labels. Might
               be helpful for factor variables.
               For instance, if you have a Gender variable with 0/1 value, and associated
               labels are male/female, this function would convert all 0 to male and
               all 1 to female and returns the new variable as factor.
}
\details{
See 'Details' in \code{\link{get_na}}.
}
\note{
Value label attributes (see \code{\link{get_labels}})
      will be removed when converting variables to factors.
}
\examples{
data(efc)
print(get_labels(efc)['c161sex'])
head(efc$c161sex)
head(as_label(efc$c161sex))

print(get_labels(efc)['e42dep'])
table(efc$e42dep)
table(as_label(efc$e42dep))

head(efc$e42dep)
head(as_label(efc$e42dep))

# structure of numeric values won't be changed
# by this function, it only applies to labelled vectors
# (typically categorical or factor variables)
str(efc$e17age)
str(as_label(efc$e17age))


# factor with non-numeric levels
as_label(factor(c("a", "b", "c")))

# factor with non-numeric levels, prefixed
x <- factor(c("a", "b", "c"))
x <- set_labels(x, labels = c("ape", "bear", "cat"))
as_label(x, prefix = TRUE)


# create vector
x <- c(1, 2, 3, 2, 4, NA)
# add less labels than values
x <- set_labels(x,
                labels = c("yes", "maybe", "no"),
                force.labels = FALSE,
                force.values = FALSE)
# convert to label w/o non-labelled values
as_label(x)
# convert to label, including non-labelled values
as_label(x, add.non.labelled = TRUE)


# create labelled integer, with missing flag
library(haven)
x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1, 2:3),
              c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
# to labelled factor, with missing labels
as_label(x, drop.na = FALSE)
# to labelled factor, missings removed
as_label(x, drop.na = TRUE)
# keep missings, and use non-labelled values as well
as_label(x, add.non.labelled = TRUE, drop.na = FALSE)


# convert labelled character to factor
dummy <- c("M", "F", "F", "X")
dummy <- set_labels(
  dummy,
  labels = c(`M` = "Male", `F` = "Female", `X` = "Refused")
)
get_labels(dummy,, "p")
as_label(dummy)

# drop unused factor levels, but preserve variable label
x <- factor(c("a", "b", "c"), levels = c("a", "b", "c", "d"))
x <- set_labels(x, labels = c("ape", "bear", "cat"))
set_label(x) <- "A factor!"
x
as_label(x, drop.levels = TRUE)

# change variable label
as_label(x, var.label = "New variable label!", drop.levels = TRUE)


# easily coerce specific variables in a data frame to factor
# and keep other variables, with their class preserved
as_label(efc, e42dep, e16sex, c172code)

}
