% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjRecode.R
\name{rec}
\alias{rec}
\title{Recode numeric variables}
\usage{
rec(x, recodes)
}
\arguments{
\item{x}{a numeric variable (vector) or a \code{\link{factor}} with numeric
levels that should be recoded.}

\item{recodes}{a string with recode pairs of old and new values. See details for
examples.}
}
\value{
A numeric variable with recoded category values.
}
\description{
Recodes the categories of a (numeric) variable \code{x} into new
               category values.
}
\details{
The \code{recodes} string has following syntax:
          \itemize{
           \item each recode pair has to be separated by a \code{;}, e.g. \code{recodes = "1=1; 2=4; 3=2; 4=3"}
           \item multiple old values that should be recoded into a new single value may be separated with comma, e.g. \code{"1,2=1; 3,4=2"}
           \item a value range is indicated by a colon, e.g. \code{"1:4=1; 5:8=2"} (recodes all values from 1 to 4 into 1, and from 5 to 8 into 2)
           \item minimum and maximum values are indicates by \emph{min} and \emph{max}, e.g. \code{"min:4=1; 5:max=2"} (recodes all values from minimum values of \code{x} to 4 into 1, and from 5 to maximum values of \code{x} into 2)
           \item all other values except specified are indicated by \emph{else}, e.g. \code{"3=1; 1=2; else=3"} (recodes 3 into 1, 1 into 2 and all other values into 3)
           \item \code{\link{NA}} values are allowed both as old and new value, e.g. \code{"NA=1; 3:5=NA"} (recodes all NA from old value into 1, and all old values from 3 to 5 into NA in the new variable)
           \item \code{"rev"} is a special token that reverses the value order (see examples)
          }
          Variable label attributes (see, for instance, \code{\link{get_var_labels}})
          are retained, however, value label attributes are removed.
}
\examples{
data(efc)
table(efc$e42dep, exclude = NULL)

# replace NA with 5
table(rec(efc$e42dep, "1=1;2=2;3=3;4=4;NA=5"), exclude = NULL)

# recode 1 to 2 into 1 and 3 to 4 into 2
table(rec(efc$e42dep, "1,2=1; 3,4=2"), exclude = NULL)

# recode 1 to 3 into 4 into 2
table(rec(efc$e42dep, "min:3=1; 4=2"), exclude = NULL)

# recode 2 to 1 and all others into 2
table(rec(efc$e42dep, "2=1; else=2"), exclude = NULL)

# reverse value order
table(rec(efc$e42dep, "rev"), exclude = NULL)
}
\seealso{
\code{\link{set_na}} for setting \code{NA} values and \code{\link{recode_to}}
           for re-shifting value ranges.
}

