% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typical.R
\name{typical_value}
\alias{typical_value}
\title{Return the typical value of a vector}
\usage{
typical_value(x, fun = "mean", weights = NULL, ...)
}
\arguments{
\item{x}{A variable.}

\item{fun}{Character vector, naming the function to be applied to
\code{x}. Currently, \code{"mean"}, \code{"weighted.mean"},
\code{"median"} and \code{"mode"} are supported, which call the
corresponding R functions (except \code{"mode"}, which calls an
internal function to compute the most common value). \code{"zero"}
simply returns 0. \strong{Note:} By default, if \code{x} is a factor,
only \code{fun = "mode"} is applicable; for all other functions (including
the default, \code{"mean"}) the reference level of \code{x} is returned.
For character vectors, only the mode is returned. You can use a named
vector to apply other different functions to numeric and categorical
\code{x}, where factors are first converted to numeric vectors, e.g.
\code{fun = c(numeric = "median", factor = "mean")}. See 'Examples'.}

\item{weights}{Name of variable in \code{x} that indicated the vector of
weights that will be applied to weight all observations. Default is
\code{NULL}, so no weights are used.}

\item{...}{Further arguments, passed down to \code{fun}.}
}
\value{
The "typical" value of \code{x}.
}
\description{
This function returns the "typical" value of a variable.
}
\details{
By default, for numeric variables, \code{typical_value()} returns the
         mean value of \code{x} (unless changed with the \code{fun}-argument).
         \cr \cr
         For factors, the reference level is returned or the most common value
         (if \code{fun = "mode"}), unless \code{fun} is a named vector. If
         \code{fun} is a named vector, specify the function for numeric
         and categorical variables as element names, e.g.
         \code{fun = c(numeric = "median", factor = "mean")}. In this case,
         factors are converted to numeric values (using \code{\link[sjmisc]{to_value}})
         and the related function is applied. You may abbreviate the names
         \code{fun = c(n = "median", f = "mean")}. See also 'Examples'.
         \cr \cr
         For character vectors the most common value (mode) is returned.
}
\examples{
data(iris)
typical_value(iris$Sepal.Length)

library(purrr)
map(iris, ~ typical_value(.x))

# example from ?stats::weighted.mean
wt <- c(5,  5,  4,  1) / 15
x <- c(3.7, 3.3, 3.5, 2.8)

typical_value(x, fun = "weighted.mean")
typical_value(x, fun = "weighted.mean", weights = wt)

# for factors, return either reference level or mode value
set.seed(123)
x <- sample(iris$Species, size = 30, replace = TRUE)
typical_value(x)
typical_value(x, fun = "mode")

# for factors, use a named vector to apply other functions than "mode"
map(iris, ~ typical_value(.x, fun = c(n = "median", f = "mean")))


}
