% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{chisq_gof}
\alias{chisq_gof}
\title{Compute model quality}
\usage{
chisq_gof(x, prob = NULL, weights = NULL)
}
\arguments{
\item{x}{A numeric vector or a \code{glm}-object.}

\item{prob}{Vector of probabilities (indicating the population probabilities)
of the same length as \code{x}'s amount of categories / factor levels.
Use \code{nrow(table(x))} to determine the amount of necessary values
for \code{prob}. Only used, when \code{x} is a vector, and not a
\code{glm}-object.}

\item{weights}{Vector with weights, used to weight \code{x}.}

\item{...}{More fitted model objects, to compute multiple coefficients of
variation at once.}
}
\value{
For vectors, returns the object of the computed \code{\link[stats]{chisq.test}}.
    For \code{glm}-objects, an object of class \code{chisq_gof} with
    following values: \code{p.value}, the p-value for the goodness-of-fit test;
    \code{z.score}, the standardized z-score for the goodness-of-fit test;
    \code{rss}, the residual sums of squares term and \code{chisq}, the pearson
    chi-squared statistic.
}
\description{
For logistic regression models, performs a Chi-squared
  goodness-of-fit-test.
}
\details{
For vectors, this function is a convenient function for the
        \code{chisq.test()}, performing goodness-of-fit test. For
        \code{glm}-objects, this function performs a goodness-of-fit test.
        A well-fitting model shows \emph{no} significant difference between the
        model and the observed data, i.e. the reported p-values should be
        greater than 0.05.
}
\examples{
data(efc)
efc$neg_c_7d <- ifelse(efc$neg_c_7 < median(efc$neg_c_7, na.rm = TRUE), 0, 1)
m <- glm(
  neg_c_7d ~ c161sex + barthtot + c172code,
  data = efc,
  family = binomial(link = "logit")
)

# goodness-of-fit test for logistic regression
chisq_gof(m)

# goodness-of-fit test for vectors against probabilities
# differing from population
chisq_gof(efc$e42dep, c(0.3,0.2,0.22,0.28))

# equal to population
chisq_gof(efc$e42dep, prop.table(table(efc$e42dep)))

}
\references{
Hosmer, D. W., & Lemeshow, S. (2000). Applied Logistic Regression. Hoboken, NJ, USA: John Wiley & Sons, Inc. \doi{10.1002/0471722146}
}
