% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bamset.R
\name{bamset}
\alias{bamset}
\title{Ramsey's BAMSET Test for Heteroskedasticity in a Linear Regression Model}
\usage{
bamset(
  mainlm,
  k = 3,
  deflator = NULL,
  correct = TRUE,
  omitatmargins = TRUE,
  omit = NULL
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} "lm", or a list
of two components: a response vector and a design matrix (in that order).
If the latter, the design matrix must begin with a column of 1s if an
intercept is to be included in the linear model. Passing an object of
class "lm" is recommended in applications; passing a list containing
the data is recommended where optimising computational performance is
important.}

\item{k}{An integer. The number of subsets (>= 2) into which the BLUS residuals are
to be partitioned. Defaults to 3, the value suggested in
\insertCite{Ramsey69;textual}{skedastic}.}

\item{deflator}{Either a character specifying a column name from the
design matrix of \code{mainlm} or an integer giving the index of a
column of the design matrix. This variable is suspected to be
related to the error variance under the alternative hypothesis.
\code{deflator} may not correspond to a column of 1's (intercept).
Default \code{NULL} means the data will be left in its current order
(e.g. in case the existing index is believed to be associated with
error variance).}

\item{correct}{A logical. Should the test statistic be divided by a scaling
constant to improve the chi-squared approximation? Defaults to
\code{TRUE}.}

\item{omitatmargins}{A logical. Should the indices of observations at the
margins of the \code{k} subsets be passed to \code{\link{blus}} as the
\code{omit} argument? If \code{TRUE} (the default), this overrides any
\code{omit} argument passed directly. If \code{FALSE}, the \code{omit}
argument must be specified and cannot be left as \code{NULL}.}

\item{omit}{A numeric vector of length \eqn{p} (the number of columns in the
linear model design matrix) giving the indices of \eqn{p} observations to omit in
the BLUS residual vector; or a character partially matching \code{"first"}
(for the first \eqn{p}) observations, \code{"last"} (for the last \eqn{p}
observations), or \code{"random"} (for a random sample of \eqn{p} indices
between 1 and \eqn{n}). Defaults to \code{"first"}.}
}
\value{
An object of \code{\link[base]{class}} "htest". If object is not
   assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the Bartlett's \eqn{M} Specification Error Test
   (BAMSET) method of \insertCite{Ramsey69;textual}{skedastic} for testing
   for heteroskedasticity in a linear regression model.
}
\details{
BAMSET is an analogue of Bartlett's \eqn{M} Test for heterogeneity of
   variances across independent samples from \eqn{k} populations. In this
   case the populations are \eqn{k} subsets of the residuals from a linear
   regression model. In order to meet the independence assumption,
   \link[=blus]{BLUS residuals} are computed, meaning that only \eqn{n-p}
   observations are used (where \eqn{n} is the number of rows and \eqn{p}
   the number of columns in the design matrix). Under the null hypothesis
   of homoskedasticity, the test statistic is asymptotically chi-squared
   distributed with \eqn{k-1} degrees of freedom. The test is right-tailed.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
bamset(mtcars_lm, deflator = "wt", k = 3)

# BLUS residuals cannot be computed with given `omit` argument and so
# omitted indices are randomised:
bamset(mtcars_lm, deflator = "wt", k = 4, omitatmargins = FALSE, omit = "last")

}
\references{
{\insertAllCited{}}
}
