% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_published_courses.R
\name{get_published_courses}
\alias{get_published_courses}
\title{Get All Published Courses}
\usage{
get_published_courses(domain, api_token, encoding_ = "UTF-8")
}
\arguments{
\item{domain}{Domain of 'Skilljar' account}

\item{api_token}{Your personalized token provided by 'Skilljar'}

\item{encoding_}{API data encoding, do not use unless there is an error}
}
\value{
A data frame with all published course data
}
\description{
Returns a data.frame with all published courses from a particular domain.
}
\details{
Utilizing the API requires a token. This must be obtained by logging in
at dashboard.skilljar.com and going to Organization -> API Credentials.
There are different strategies for storing api tokens securely. It is 
an unnecessary risk to store the token in the script!
}
\examples{
\dontrun{
# Retrieve all published courses
courses <- get_published_courses(domain = "training.mycompany.com",
api_token = "my-token")
}
}
\seealso{
See \url{https://api.skilljar.com/docs/} for documentation on
the 'Skilljar' API.
}
