% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liMCMC.R
\name{liMCMC}
\alias{liMCMC}
\title{Runs MCMC algorithm for performing inference using the model from Li et al. (2022)}
\usage{
liMCMC(
  Y,
  cluster,
  S,
  hyperparams = c(kappa = 180, gamma = 6, alpha = 2, beta = 20),
  initialParams = list(pi = c(1/3, 1/3, 1/3), lambdais = rep(30,
    length(unique(cycleDat$Individual))), piis = rep(0.2,
    length(unique(cycleDat$Individual))), ss = sample(0:S, nrow(cycleDat), replace =
    TRUE)),
  reps = 1000
)
}
\arguments{
\item{Y}{A vector of observed cycle lengths.}

\item{cluster}{A vector indicating the individual cluster/group membership for each observation Y.}

\item{S}{Integer. The maximum number of skips to consider possible.}

\item{hyperparams}{Named numeric vector of hyperparameters containing the
elements: kappa, gamma, alpha, beta. NOTE: MUST BE IN CORRECT ORDER.
\itemize{
\item \code{kappa}: Numeric value, shape parameter of Gamma distribution for Lambda_i.
\item \code{gamma}: Numeric value, rate parameter of Gamma distribution for Lambda_i.
\item \code{alpha}: Numeric value, shape1 parameter of Beta distribution for Pi_i.
\item \code{beta}:  Numeric value, shape2 parameter of Beta distribution for Pi_i.
}}

\item{initialParams}{A list of initial parameter values for the MCMC algorithm.
Default values are provided for pi, lambdais, piis, ss.}

\item{reps}{The number of MCMC iterations (steps) to perform. Default is 1000.}
}
\value{
A list containing the MCMC draws for each parameter at each iteration. Each element
in the list is itself a list containing:
\describe{
\item{ijDat}{A data.frame with updated parameters at the individual-observation level: Individual, ys, lambdais, piis, ss.}
\item{iDat}{A data.frame with updated parameters at the individual level: Individual, lambdas, pis.}
\item{kappa}{Fixed value of hyperparameter kappa.}
\item{gamma}{Fixed value of hyperparameter gamma.}
\item{alpha}{Fixed value of hyperparameter alpha.}
\item{beta}{Fixed value of hyperparamter beta.}
\item{S}{Fixed input value S.}
\item{indFirst}{A logical vector indicating the first occurrence of each individual.}
}
}
\description{
This function performs inference on cycle length data, assuming the model from Li et al. (2022). It is important to note
that Li et al. does not actually use this algorithm as they target a particular analytic posterior predictive distribution,
and solve directly. However, we are targeting a different posterior and thus use this MCMC to perform inference.
}
\references{
Li, Kathy, et al. "A predictive model for next cycle start date that accounts for adherence in menstrual self-tracking." Journal of the American Medical Informatics Association 29.1 (2022): 3-11.
}
\seealso{
\code{\link{gibbsStepLi}}
}
