% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklarsomega.R
\name{simulate.sklarsomega}
\alias{simulate.sklarsomega}
\title{Simulate a Sklar's Omega dataset(s).}
\usage{
\method{simulate}{sklarsomega}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{object}{a fitted model object.}

\item{nsim}{number of datasets to simulate. Defaults to 1.}

\item{seed}{either \code{NULL} or an integer that will be used in a call to \code{\link{set.seed}} before simulating the response vector(s). If set, the value is saved as the \code{"seed"} attribute of the returned value. The default (\code{NULL}) will not change the random generator state, and \code{\link{.Random.seed}} will be returned as the \code{"seed"} attribute.}

\item{...}{additional arguments.}
}
\value{
A data frame having \code{nsim} columns, each of which contains a simulated response vector. Said data frame has a \code{"seed"} attribute, which takes the value of the \code{seed} argument or the value of \code{\link{.Random.seed}}.
}
\description{
Simulate a Sklar's Omega dataset(s).
}
\details{
This function simulates one or more responses distributed according to the fitted model.
}
\examples{
# The following data were presented in Krippendorff (2013).

data.nom = matrix(c(1,2,3,3,2,1,4,1,2,NA,NA,NA,
                    1,2,3,3,2,2,4,1,2,5,NA,3,
                    NA,3,3,3,2,3,4,2,2,5,1,NA,
                    1,2,3,3,2,4,4,1,2,5,1,NA), 12, 4)
colnames(data.nom) = c("c.1.1", "c.2.1", "c.3.1", "c.4.1")
fit.nom = sklars.omega(data.nom, level = "nominal", confint = "none")
summary(fit.nom)

# Simulate three datasets from the fitted model, and then
# display the first dataset in matrix form.

sim = simulate(fit.nom, nsim = 3, seed = 42)
data.sim = t(fit.nom$data)
data.sim[! is.na(data.sim)] = sim[, 1]
data.sim = t(data.sim)
data.sim
}
