% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotZscore}
\alias{plotZscore}
\title{Plot a z-score transformed curvigram}
\usage{
plotZscore(signif, obj, obj.label = T, xlim = NULL)
}
\arguments{
\item{signif}{A \emph{skyscapeR.sig} object created with \code{\link{sigTest}}.}

\item{obj}{(Optional) A \emph{skyscapeR.object} object created with \code{\link{sky.objects}}
for displaying the declination of celestial objects.}

\item{obj.label}{(Optional) Boolean to control whether to label the celestial objects in
the curvigram. Defaults to \emph{TRUE}.}

\item{xlim}{Array of two values restricting the horizontal range of the plot.}
}
\description{
This function creates a plot of a z-score transformed curvigram, which is to say the
curvigram transformed into sigma units, based on a previously generated significance test.
}
\examples{
\dontrun{
data(RugglesRSC)
curv <- curvigram(RugglesRSC$Dec, unc=2)
sig <- sigTest(curv, nh.Uniform(c(57,2)))

plotZscore(sig)
}
}
\seealso{
\code{\link{sigTest}}
}
