% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_bot.r, R/zcamels.r
\name{slackr_bot}
\alias{slackr_bot}
\alias{slackrBot}
\title{Send result of R expressions to a Slack channel via webhook API}
\usage{
slackr_bot(
  ...,
  channel = Sys.getenv("SLACK_CHANNEL"),
  username = Sys.getenv("SLACK_USERNAME"),
  icon_emoji = Sys.getenv("SLACK_ICON_EMOJI"),
  incoming_webhook_url = Sys.getenv("SLACK_INCOMING_URL_PREFIX")
)

slackrBot(
  ...,
  channel = Sys.getenv("SLACK_CHANNEL"),
  username = Sys.getenv("SLACK_USERNAME"),
  icon_emoji = Sys.getenv("SLACK_ICON_EMOJI"),
  incoming_webhook_url = Sys.getenv("SLACK_INCOMING_URL_PREFIX")
)
}
\arguments{
\item{...}{expressions to be sent to Slack}

\item{channel}{which channel to post the message to (chr)}

\item{username}{what user should the bot be named as (chr)}

\item{icon_emoji}{what emoji to use (chr) \code{""} will mean use the default}

\item{incoming_webhook_url}{which \code{slack.com} API endpoint URL to use
(see section \bold{Webhook URLs} for details)}
}
\description{
Takes an \code{expr}, evaluates it and sends the output to a Slack
chat destination via the webhook API. Useful for logging, messaging on long
compute tasks or general information sharing.
}
\details{
By default, everyting but \code{expr} will be looked for in a "\code{SLACK_}"
environment variable. You can override or just specify these values directly
instead, but it's probably better to call \code{\link{slackr_setup}} first.

This function uses the incoming webhook API. The webhook will have a default
channel, username, icon etc, but these can be overridden.
}
\note{
You need a \url{https://www.slack.com} account and will also need to
  setup an incoming webhook: \url{https://api.slack.com/}. Old style webhooks are
  no longer supported.
}
\section{Webhook URLs}{
 Webhook URLs look like: \itemize{

  \item \code{https://hooks.slack.com/services/XXXXX/XXXXX/XXXXX}

  }

OLD STYLE WEBHOOKS ARE NO LONGER SUPPORTED
}

\examples{
\dontrun{
slackr_setup()
slackr_bot("iris info", head(iris), str(iris))

# or directly
slackr_bot("Test message", username="slackr", channel="#random",
  incoming_webhook_url="https://hooks.slack.com/services/XXXXX/XXXXX/XXXXX")
}
}
\seealso{
\code{\link{slackrSetup}}, \code{\link{slackr}},
  \code{\link{dev_slackr}}, \code{\link{save_slackr}},
  \code{\link{slackr_upload}}
}
