% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_save.R
\name{slackr_save}
\alias{slackr_save}
\title{Save R objects to an RData file on Slack}
\usage{
slackr_save(
  ...,
  channels = Sys.getenv("SLACK_CHANNEL"),
  file = "slackr",
  token = Sys.getenv("SLACK_TOKEN"),
  initial_comment = NULL,
  title = NULL,
  thread_ts = NULL
)
}
\arguments{
\item{...}{objects to store in the R data file.}

\item{channels}{Comma-separated list of channel names or IDs where the file will be shared.}

\item{file}{filename (without extension) to use.}

\item{token}{Authentication token bearing required scopes.}

\item{initial_comment}{The message text introducing the file in specified channels.}

\item{title}{Title of file.}

\item{thread_ts}{Provide another message's ts value to upload this file as a reply. Never use a reply's ts value; use its parent instead.}
}
\value{
\code{httr} response object from \code{POST} call
}
\description{
\code{slackr_save} enables you upload R objects (as an R data file)
to Slack and (optionally) post them to one or more channels
(if \code{channels} is not empty).
}
\examples{
\dontrun{
slackr_setup()
slackr_save(mtcars, channels = "#slackr", file = "mtcars")
}
}
\seealso{
\code{\link[=slackr_setup]{slackr_setup()}}, \code{\link[=slackr_dev]{slackr_dev()}}, \code{\link[=slackr_upload]{slackr_upload()}}
}
