% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kd.R
\name{kd}
\alias{kd}
\title{Difference of estimated K functions}
\usage{
kd(x, case = 2, r = NULL, rmax = rmax, breaks = NULL,
  correction = c("border", "isotropic", "Ripley", "translate"),
  nlarge = 3000, domain = NULL, var.approx = FALSE, ratio = FALSE)
}
\arguments{
\item{x}{A \code{ppp} object from the \code{spatstat} 
package with marks for the case and control groups.}

\item{case}{The position of the name of the "case" group 
in \code{levels(x$marks)}.  The default is 2.  
\code{x$marks} is assumed to be a factor.  Automatic
conversion is attempted if it is not.}

\item{r}{
    Optional. Vector of values for the argument \eqn{r} at which \eqn{K(r)} 
    should be evaluated. Users are advised \emph{not} to specify this
    argument; there is a sensible default. If necessary, specify \code{rmax}.
  }

\item{rmax}{
    Optional. Maximum desired value of the argument \eqn{r}.
  }

\item{breaks}{
    This argument is for internal use only.
  }

\item{correction}{
    Optional. A character vector containing any selection of the
    options \code{"none"}, \code{"border"}, \code{"bord.modif"},
    \code{"isotropic"}, \code{"Ripley"}, \code{"translate"},
    \code{"translation"}, \code{"rigid"},
    \code{"none"}, \code{"good"} or \code{"best"}.
    It specifies the edge correction(s) to be applied.
    Alternatively \code{correction="all"} selects all options.
  }

\item{nlarge}{
    Optional. Efficiency threshold.
    If the number of points exceeds \code{nlarge}, then only the
    border correction will be computed (by default), using a fast algorithm.
  }

\item{domain}{Optional. Calculations will be restricted 
to this subset of the window. See Details of 
\code{\link[spatstat]{Kest}}.}

\item{var.approx}{Logical. If \code{TRUE}, the approximate
    variance of \eqn{\hat K(r)}{Kest(r)} under CSR
    will also be computed.
  }

\item{ratio}{
    Logical. 
    If \code{TRUE}, the numerator and denominator of
    each edge-corrected estimate will also be saved,
    for use in analysing replicated point patterns.
  }
}
\value{
Returns an \code{fv} object.  See documentation 
  for \code{spatstat::Kest}.
}
\description{
\code{kd} determines the difference in estimated K 
functions for a set of cases and controls.
}
\details{
This function relies internally on the 
\code{\link[spatstat]{Kest}} and 
\code{\link[spatstat]{eval.fv}} functions from the 
\code{spatstat} package.  The arguments are essentially
the same as the \code{\link[spatstat]{Kest}} function, 
and the user is referred there for more details about
the various arguments.
}
\examples{
data(grave)
# kd = kd(grave)
# plot(kd)
}
\references{
Waller, L.A. and Gotway, C.A. (2005). Applied
  Spatial Statistics for Public Health Data. Hoboken, NJ:
  Wiley.
}
\seealso{
\code{\link[spatstat]{Kest}}, 
  \code{\link[spatstat]{eval.fv}}
}
\author{
Joshua French
}
