% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movmov.R
\name{fitMM}
\alias{fitMM}
\alias{estVarMM}
\title{Fit a Moving-Moving Model with 2 Embedded Brownian Motion}
\usage{
fitMM(
  data,
  start,
  logtr = FALSE,
  method = "Nelder-Mead",
  optim.control = list(),
  integrControl = integr.control()
)

estVarMM(
  est_theta,
  data,
  nBS,
  detailBS = FALSE,
  numThreads = 1,
  integrControl = integr.control()
)
}
\arguments{
\item{data}{data used to process estimation}

\item{start}{starting value of the model, a vector of four components
in the order of rate for moving1, rate for moving2,
and volatility1(larger), volatility2(smaller).}

\item{logtr}{logical, if TRUE parameters are estimated on the log scale.}

\item{method}{the method argument to feed \code{optim}.}

\item{optim.control}{a list of control to be passed to \code{optim}.}

\item{integrControl}{a list of control parameters for the \code{integrate}
function: rel.tol, abs.tol, subdivision.}

\item{est_theta}{estimators of MRME model}

\item{nBS}{number of bootstrap.}

\item{detailBS}{whether or not output estimation results during bootstrap,
which can be used to generate bootstrap CI.}

\item{numThreads}{the number of threads for parallel computation. If its value
is greater than 1, then parallel computation will be processed. Otherwise,
serial computation will be processed.}
}
\value{
a list of the following components:
\item{estimate}{the esimated parameter vector}
\item{loglik}{maximized loglikelihood or composite loglikelihood
evaluated at the estimate}
\item{convergence}{convergence code from \code{optim}}
}
\description{
Fit a Moving-Moving Model with 2 Embedded Brownian Motion with animal
movement data at discretely observation times by maximizing a full
likelihood constructed from the marginal density of increment.
'estVarMM' uses parametric bootstrap to obtain variance matrix
of estimators from 'fitMM'.
}
\examples{
\dontrun{
## time consuming example
tgrid <- seq(0, 100, length=100)
set.seed(123)
dat <- rMM(tgrid, 1, 0.1, 1, 0.1, "m1")

## fit whole dataset to the MR model
fit <- fitMM(dat, start=c(1, 0.1, 1, 0.1))
fit

var <- estVarMM(fit$estimate, dat, nBS = 10, numThreads = 6)
var
}
}
\references{
Yan, J., Chen, Y., Lawrence-Apfel, K., Ortega, I. M., Pozdnyakov, V.,
Williams, S., and Meyer, T. (2014) A moving-resting process with an
embedded Brownian motion for animal movements.
Population Ecology. 56(2): 401--415.

Pozdnyakov, V., Elbroch, L., Labarga, A., Meyer, T., and Yan, J.
(2017) Discretely observed Brownian motion governed by telegraph
process: estimation. Methodology and Computing in Applied Probability.
doi:10.1007/s11009-017-9547-6.
}
