% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.plot}
\alias{smbinning.plot}
\title{Plots after binning}
\usage{
smbinning.plot(ivout, option = "dist", sub = "")
}
\arguments{
\item{ivout}{An object generated by binning.}

\item{option}{Distribution ("dist"), Good Rate ("goodrate"), Bad Rate ("badrate"), and Weight of Evidence ("WoE").}

\item{sub}{Subtitle for the chart (optional).}
}
\description{
It generates plots for distribution, bad rate, and weight of evidence after running \code{smbinning} 
and saving its output.
}
\examples{
# Training and testing samples (Just some basic formality for Modeling)
pop=chileancredit # Set population
train=subset(pop,Rnd<=0.7) # Training sample
test=subset(pop,Rnd>0.7) # Testing sample
rm(chileancredit) # Remove original dataset

# Plot: Example 1 for a numeric variable
result=smbinning(df=train,y="FlagGB",x="LnTOB") # Run and save result
par(mfrow=c(2,2))
boxplot(train$LnTOB~train$FlagGB,
        horizontal=TRUE, frame=FALSE, col="lightgray",main="Distribution")
mtext("Time on Books (Months)",3)
smbinning.plot(result,option="dist",sub="Time on Books (Months)")
smbinning.plot(result,option="badrate",sub="Time on Books (Months)")
smbinning.plot(result,option="WoE",sub="Time on Books (Months)")
par(mfrow=c(1,1))

# Plot: Example 2 for a factor variable
result=smbinning.factor(df=train,y="FlagGB",x="CuWealth",maxcat=11) # Run and save result
smbinning.plot(result,option="dist",sub="Income Level")
smbinning.plot(result,option="badrate",sub="Income Level")
smbinning.plot(result,option="WoE",sub="Income Level")
}
