% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm4.R
\name{sm4_encrypt_ecb_to_file}
\alias{sm4_encrypt_ecb_to_file}
\alias{sm4_decrypt_ecb_from_file}
\alias{sm4_encrypt_cbc_to_file}
\alias{sm4_decrypt_cbc_from_file}
\title{SM4 Encrypt/Decrypt - file}
\usage{
sm4_encrypt_ecb_to_file(input_file, output_file, key)

sm4_decrypt_ecb_from_file(input_file, output_file, key)

sm4_encrypt_cbc_to_file(input_file, output_file, key, iv)

sm4_decrypt_cbc_from_file(input_file, output_file, key, iv)
}
\arguments{
\item{input_file}{the original file for encrypt, or the encrypted file for decrypt}

\item{output_file}{the encrypted file for encrypt, or the decrypted file for decrypt}

\item{key}{the key, must be a raw vector of length 16}

\item{iv}{the initialization vector, must be a raw vector of 16}
}
\value{
\describe{
  \item{\link{sm4_encrypt_ecb_to_file}}{returns nothing, and an encrypted file will be saved in the specified path using ecb mode}
  \item{\link{sm4_decrypt_ecb_from_file}}{returns nothing, and a decrypted file will be saved in the specified path using ecb mode}
  \item{\link{sm4_encrypt_cbc_to_file}}{returns nothing, and an encrypted file will be saved in the specified path using cbc mode}
  \item{\link{sm4_decrypt_cbc_from_file}}{returns nothing, and a decrypted file will be saved in the specified path using cbc mode}
}
}
\description{
For ease of use, we have provided functions to encrypt or decrypt data directly from files.
}
\examples{
\dontrun{
  key <- '1234567812345678' |> charToRaw()
  iv <- '0000000000000000' |> charToRaw()
  ## ecb mode
  sm4_encrypt_ecb_to_file('a.txt', 'a.enc', key)
  sm4_decrypt_ecb_from_file('a.enc', 'a.dec', key)
  ## cbc mode
  sm4_encrypt_cbc_to_file('a.txt', 'a.enc', key, iv)
  sm4_decrypt_cbc_from_file('a.enc', 'a.dec', key, iv)
}
}
