% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlf.zones.R
\name{mlf.zones}
\alias{mlf.zones}
\title{Determine zones for the maxima likelihood
first algorithm.}
\usage{
mlf.zones(
  coords,
  cases,
  pop,
  w,
  ex = sum(cases)/sum(pop) * pop,
  ubpop = 0.5,
  ubd = 1,
  longlat = FALSE
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{ubd}{A proportion in (0, 1].  The distance of
potential clusters must be no more than \code{ubd * m},
where \code{m} is the maximum intercentroid distance
between all coordinates.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}
}
\value{
Returns a list with elements: \item{zones}{A list
  contained the location ids of each potential cluster.}
  \item{loglikrat}{The loglikelihood ratio for each zone
  (i.e., the log of the test statistic).}
  \item{cases}{The observed number of cases in each
  zone.} \item{expected}{The expected number of cases
  each zone.} \item{pop}{The total population in each
  zone.}
}
\description{
\code{mlf.zones} determines the most likely cluster zone
obtained by implementing the maxima likelihood first
scann method of Yao et al. (2011).  Note that this is
really just a special case of the dynamic minimum
spanning tree (DMST) algorithm of Assuncao et al. (2006)
}
\details{
Each step of the mlf scan test seeks to maximize the
likelihood ratio test statistic used in the original
spatial scan test (Kulldorff 1997).  The first zone
considered is the region that maximizes this likelihood
ration test statistic, providing that no more than
\code{ubpop} proportion of the total population is in the
zone.  The second zone is the first zone and the
connected region that maximizes the scan statistic,
subject to the population and distance constraints.  This
pattern continues until no additional zones can be added
due to population or distance constraints.

Every zone considered must have a total population less
than \code{ubpop * sum(pop)} in the study area.
Additionally, the maximum intercentroid distance for the
regions within a zone must be no more than \code{ubd *
the maximum intercentroid distance across all regions}.
}
\examples{
data(nydf)
data(nyw)
coords <- as.matrix(nydf[, c("x", "y")])
mlf.zones(coords,
  cases = floor(nydf$cases),
  pop = nydf$pop, w = nyw, longlat = TRUE
)
}
\references{
Yao, Z., Tang, J., & Zhan, F. B. (2011).
  Detection of arbitrarily-shaped clusters using a
  neighbor-expanding approach: A case study on murine
  typhus in South Texas. International Journal of Health
  Geographics, 10(1), 1.
}
\author{
Joshua French
}
