% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{orders}
\alias{orders}
\alias{orders.default}
\alias{lags}
\alias{lags.default}
\alias{modelType}
\alias{modelType.default}
\alias{model.type}
\title{Functions that extract values from the fitted model}
\usage{
orders(object, ...)

lags(object, ...)

modelType(object, ...)

model.type(object, ...)
}
\arguments{
\item{object}{Model estimated using one of the functions of smooth package.}

\item{...}{Currently nothing is accepted via ellipsis.}
}
\value{
Either vector or list with values is returned.
\code{orders()} in case of ssarima returns list of values:
\itemize{
\item \code{ar} - AR orders.
\item \code{i} - I orders.
\item \code{ma} - MA orders.
}
}
\description{
These functions allow extracting orders and lags for \code{ssarima()}, \code{ges()} and \code{sma()}
and type of model from \code{es()} and \code{ces()}.
}
\details{
\code{orders()} and \code{lags()} are useful only for SSARIMA, GES and SMA. They return \code{NA} for other functions.
This can also be applied to \code{arima()}, \code{Arima()} and \code{auto.arima()} functions from stats and forecast packages.
\code{modelType()} is useful only for ETS and CES. They return \code{NA} for other functions.
This can also be applied to \code{ets()} function from forecast package.
}
\examples{

x <- rnorm(100,0,1)

# Just as example. orders and lags do not return anything for ces() and es(). But modelType() does.
ourModel <- ces(x, h=10)
orders(ourModel)
lags(ourModel)
modelType(ourModel)
# And as another example it does the opposite for ges() and ssarima()
ourModel <- ges(x, h=10, orders=c(1,1), lags=c(1,4))
orders(ourModel)
lags(ourModel)
modelType(ourModel)

# Finally these values can be used for simulate functions or original functions.
ourModel <- auto.ssarima(x)
ssarima(x, orders=orders(ourModel), lags=lags(ourModel), constant=ourModel$constant)
sim.ssarima(orders=orders(ourModel), lags=lags(ourModel), constant=ourModel$constant)

}
\seealso{
\link[forecast]{forecast}, \link[smooth]{ssarima}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{htest}
\keyword{ts}
