% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-measures.R
\name{Accuracy}
\alias{Accuracy}
\title{Accuracy of forecasts}
\usage{
Accuracy(holdout, forecast, actual, digits = 3)
}
\arguments{
\item{holdout}{The vector of the holdout values.}

\item{forecast}{The vector of forecasts produced by a model.}

\item{actual}{The vector of actual in-sample values.}

\item{digits}{Number of digits of the output.}
}
\value{
The functions returns the named vector of errors:
\itemize{
\item MPE,
\item cbias,
\item MAPE,
\item MASE,
\item sMAE,
\item RelMAE,
\item RelMSE,
\item RelAME,
\item sMSE,
\item sPIS,
\item sCE.
}
For the details on these errors, see \link[smooth]{Errors}.
}
\description{
Function calculates several error measures using the provided
data for the holdout sample.
}
\examples{


y <- rnorm(100,10,2)
esmodel <- es(y[1:90],model="ANN",h=10)

Accuracy(y[91:100],esmodel$forecast,y[1:90],digits=5)

}
\references{
\itemize{
\item Fildes, R. (1992). The evaluation of
extrapolative forecasting methods. International Journal of Forecasting, 8,
pp.81-98.
\item Hyndman R.J., Koehler A.B. (2006). Another look at measures of
forecast accuracy. International Journal of Forecasting, 22, pp.679-688.
\item Makridakis, S. (1993). Accuracy measures: Theoretical and practical
concerns. International Journal of Forecasting, 9, pp.527-529.
\item Petropoulos F., Kourentzes N. (2015). Forecast combinations for
intermittent demand. Journal of the Operational Research Society, 66,
pp.914-924.
\item Wallstrom P., Segerstedt A. (2010). Evaluation of forecasting error
measurements and techniques for intermittent demand. International Journal
of Production Economics, 128, pp.625-636.
}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
