% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisher_corr.R
\name{Fcorr}
\alias{Fcorr}
\alias{dFcorr}
\alias{pFcorr}
\alias{qFcorr}
\alias{rFcorr}
\title{Fisher's transformation of the product moment correlation coefficient}
\usage{
dFcorr(x, N, rho = 0, log = FALSE)

pFcorr(q, N, rho = 0, lower.tail = TRUE, log.p = FALSE)

qFcorr(p, N, rho = 0, lower.tail = TRUE, log.p = FALSE)

rFcorr(n, N, rho = 0, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{x, q}{Numeric vectors of quantiles.}

\item{N}{Numeric vector.  Number of observations, (N > 3).}

\item{rho}{Numeric vector.  Population correlations, (-1 < rho < 1).}

\item{log, log.p}{A logical scalar; if TRUE, probabilities p are given as
log(p).}

\item{lower.tail}{A logical scalar.  If TRUE (default), probabilities
are P[X <= x], otherwise, P[X > x].}

\item{p}{A numeric vector of probabilities in [0,1].}

\item{n}{Numeric scalar.  The number of observations to be simulated.
If \code{length(n) > 1} then \code{length(n)} is taken to be the number
required.}
}
\description{
Density, distribution function, quantile function and random generator
for the distribution of Fisher's transformation of product moment
correlation, based on a random sample from a bivariate normal distribution
}
\details{
These functions rely on the
  \code{\link[SuppDists:Pearson]{correlation coefficient}}
  functions in the SuppDists package.  SuppDists must be installed in order
  for these functions to work.
}
\examples{
dFcorr(-1:1, N = 10)
dFcorr(0, N = 11:20)

pFcorr(0.5, N = 10)
pFcorr(0.5, N = 10, rho = c(0, 0.3))

qFcorr((1:9)/10, N = 10, rho = 0.2)
qFcorr(0.5, N = c(10, 20), rho = c(0, 0.3))

rFcorr(6, N = 10, rho = 0.6)
}
\references{
Fisher, R. A. (1915). Frequency distribution of the values of
  the correlation coefficient in samples of an indefinitely large
  population. \emph{Biometrika}, \strong{10}(4), 507-521.

Fisher, R. A. (1921). On the "probable error" of a coefficient
  of correlation deduced from a small sample. \emph{Metron}, \strong{1},
  3-32.
  \url{https://digital.library.adelaide.edu.au/dspace/bitstream/2440/15169/1/14.pdf}
}
\seealso{
\code{\link[SuppDists:Pearson]{correlation coefficient}} in the
  SuppDists package for dpqr functions for the untransformed product moment
  correlation coefficient.

\code{\link{correlation}}: correlation sampling distribution movie.
}
