% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{PT_ZB18a}
\alias{PT_ZB18a}
\alias{PT-ZB18a}
\title{Full Astronomical Solution ZB18a for the past 100 Myr}
\format{
\subsection{\code{get_solution("PT-ZB18a")}}{

A data frame with 250,001 rows and 20 columns:
\describe{
\item{t}{Time \eqn{t} (days).}
\item{age}{Age in thousands of years before present (ka).}
\item{aa}{Semimajor axis \eqn{a} in astronomical units (au).}
\item{ee}{Eccentricity \eqn{e} (unitless).}
\item{inc}{Inclination \eqn{I} (degrees).}
\item{lph}{Longitude of perihelion \eqn{\varpi} (degrees).}
\item{lan}{Longitude of the ascending node \eqn{\Omega} (degrees).}
\item{arp}{Argument of perihelion \eqn{\omega} (degrees).}
\item{mna}{Mean anomaly \eqn{M} (degrees).}

The following columns were computed from the above input with \code{\link[=prepare_solution]{prepare_solution()}}:

\item{lphu}{Unwrapped longitude of perihelion \eqn{\varpi} (degrees without
jumps).}

\item{lanu}{Unwrapped longitude of the ascending node \eqn{\Omega}
(degrees without jumps).}

\item{hh}{Variable: \eqn{e\sin(\varpi)}{ee * sin(lph / R2D)}.}

\item{kk}{Variable: \eqn{e\cos(\varpi)}{ee * cos(lph / R2D)}.}

\item{pp}{Variable: \eqn{2\sin(0.5I)\sin(\Omega)}{2 * sin(0.5 * inc / R2D) *
  sin(lan / R2D)}.}

\item{qq}{Variable: \eqn{2\sin(0.5I)\cos(\Omega)}{2 * sin(0.5 * inc / R2D) *
  cos(lan / R2D)}.}

\item{cc}{Helper: \eqn{\cos(I)}{cos(inc / R2D)}.}

\item{dd}{Helper: \eqn{\cos(I)/2}{cos(inc / R2D / 2)}.}

\item{nnx, nny, nnz}{The \eqn{x}, \eqn{y}, and \eqn{z}-components of the
Eart's orbit unit normal vector \eqn{\vec{n}}{n}, normal to Earth's
instantaneous orbital plane.}

}
}
}
\source{
\itemize{
\item All astronomical solutions by Zeebe can be found on
\url{http://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}.
They can be loaded into R quickly, using \code{\link[=get_solution]{get_solution()}}.
}
}
\description{
The HNBody output of Zeebe & Lourens (2019) after some pre-processing using
\code{\link[=prepare_solution]{prepare_solution()}}. The wikipedia page on \href{https://en.wikipedia.org/wiki/Orbital_elements}{Orbital elements} describes what the
components relate to in order to uniquely specify an orbital plane. The
function asks to download the files to the user's cache directory so that
they can be accessed more quickly in the future.
}
\references{
Zeebe, R. E., & Lourens, L. J. (2019). Solar System chaos and the
Paleocene–Eocene boundary age constrained by geology and astronomy.
\emph{Science}, 365(6456), 926–929. \doi{10.1126/science.aax0612}.

Zeebe, R. E. and Lourens, L. J. (2022). A deep-time dating tool for
paleo-applications utilizing obliquity and precession cycles: The role of
dynamical ellipticity and tidal dissipation. \emph{Paleoceanography and
Paleoclimatology}. \doi{10.1029/2021PA004349}
}
\seealso{
\code{\link[=prepare_solution]{prepare_solution()}}
}
