% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contact_matrix.r
\name{contact_matrix}
\alias{contact_matrix}
\title{Generate a contact matrix from diary survey data}
\usage{
contact_matrix(survey, countries = c(), survey.pop, age.limits, filter,
  n = 1, bootstrap, counts = FALSE, symmetric = FALSE, split = FALSE,
  missing.participant.age = c("remove", "keep"),
  missing.contact.age = c("sample", "remove", "keep"), weights = c(),
  weigh.dayofweek = FALSE, quiet = FALSE, ...)
}
\arguments{
\item{survey}{a DOI (see \code{\link{list_surveys}}), or a numerical id (corresponding to the numbers returned in the \code{id} column returned by \code{\link{list_surveys}}), or a character vector of file names, or a \code{\link{survey}} object (in which case only cleaning is done).}

\item{countries}{limit to one or more countries; if not given, will use all countries in the survey; these can be given as country names or 2-letter (ISO Alpha-2) country codes}

\item{survey.pop}{survey population -- either a data frame with columns 'lower.age.limit' and 'population', or a character vector giving the name(s) of a country or countries from the list that can be obtained via \code{wpp_countries}; if not given, will use the country populations from the chosen countries, or all countries in the survey if \code{countries} is not given}

\item{age.limits}{lower age limits of age groups to extract}

\item{filter}{any filters to apply to the data, given as list of the form (column=filter_value) - only contacts that have 'filter_value' in 'column' will be considered}

\item{n}{number of matrices to sample}

\item{bootstrap}{whether to sample participants and contacts randomly using a bootstrap; by default, will use bootstrap if n > 1}

\item{counts}{whether to return counts (instead of means)}

\item{symmetric}{whether to make matrix symmetric}

\item{split}{whether to split the number of contacts and assortativity}

\item{missing.participant.age}{if set to "remove", participants without age information are removed; if set to "keep", participants with missing age are kept and treated as a separate age group}

\item{missing.contact.age}{if set to "sample", contacts without age information are sampled from all the contacts of participants of the same age group; if set to "remove", participants that that have contacts without age information are removed; if set to "keep", contacts with missing age are kept and treated as a separate age group}

\item{weights}{columns that contain weights}

\item{weigh.dayofweek}{whether to weigh the day of the week (weight 5 for weekdays ans 2 for weekends)}

\item{quiet}{if set to TRUE, output is reduced}

\item{...}{further arguments to pass to \code{\link{get_survey}}, \code{\link{check}} and \code{\link{pop_age}} (e.g., column names)}
}
\value{
a list of sampled contact matrices, and the underlying demography of the surveyed population
}
\description{
Samples a contact survey using a bootstrap
}
\examples{
data(polymod)
contact_matrix(polymod, countries = "United Kingdom", age.limits = c(0, 1, 5, 15))
}
\author{
Sebastian Funk
}
