\name{loafercreek}
\alias{loafercreek}
\alias{andic.subset}
\alias{gopheridge}
\alias{mineralKing}
\alias{cisne}

\docType{data}
\title{Example SoilProfilecollection Objects Returned by fetchNASIS().}
\description{Several examples of soil profile collections returned by fetchNASIS() as SoilProfileCollection objects.}
\usage{
data(loafercreek)
data(gopheridge)
data(mineralKing)
}
\format{
\preformatted{
Formal class 'SoilProfileCollection' [package "aqp"] with 7 slots
  ..@ idcol     : chr "peiid"
  ..@ depthcols : chr [1:2] "hzdept" "hzdepb"
  ..@ metadata  :'data.frame':	1 obs. of  1 variable:
  .. ..$ depth_units: chr "cm"
  ..@ horizons  :'data.frame':	356 obs. of  54 variables:
  .. ..$ peiid               : int [1:356] 207252 207252 207252 207252 207252 242808 242808 242808 242808 242808 ...
  .. ..$ phiid               : int [1:356] 1018157 1018156 1018155 1018154 1018153 1148313 1148312 1148311 1148310 1148309 ...
  .. ..$ hzname              : chr [1:356] "A" "Bt1" "Bt2" "Bt3" ...
  .. ..$ genhz               : chr [1:356] "A" "Bt1" "Bt2" "Bt2" ...
  .. ..$ hzdept              : int [1:356] 0 18 41 61 81 0 3 5 10 18 ...
  .. ..$ hzdepb              : num [1:356] 18 41 61 81 152 3 5 10 18 36 ...
  .. ..$ clay                : num [1:356] 34 32 34 32 NA ...
  .. ..$ silt                : num [1:356] 21 28 31 33 NA ...
  .. ..$ sand                : num [1:356] 45 40 35 35 NA ...
  .. ..$ fragvoltot          : num [1:356] 0 0 0 0 0 0 0 6 11 63 ...
  .. ..$ texture             : chr [1:356] "CBV-CL" "CB-CL" "CB-CL" "CBX-CL" ...
  .. ..$ texcl               : Factor w/ 21 levels "cos","s","fs",..: 17 17 17 17 NA NA NA 13 13 13 ...
  .. ..$ lieutex             : Factor w/ 58 levels "ashy","apum",..: NA NA NA NA NA 44 45 NA NA NA ...
  .. ..$ phfield             : num [1:356] 6.4 6.5 6.5 6.7 NA ...
  .. ..$ effclass            : Factor w/ 5 levels "very slight",..: 5 5 5 5 NA NA NA 5 5 5 ...
  .. ..$ labsampnum          : chr [1:356] NA NA NA NA ...
  .. ..$ rupresblkdry        : Factor w/ 11 levels "loose","soft",..: 5 6 6 6 NA NA NA 5 6 7 ...
  .. ..$ stickiness          : Factor w/ 4 levels "moderately sticky",..: 3 1 1 1 NA NA NA 3 3 1 ...
  .. ..$ plasticity          : Factor w/ 4 levels "moderately plastic",..: 1 1 1 1 NA NA NA 2 3 1 ...
  .. ..$ texture_class       : chr [1:356] "cl" "cl" "cl" "cl" ...
  .. ..$ d_r                 : num [1:356] 0.595 0.503 0.503 0.522 NA ...
  .. ..$ d_g                 : num [1:356] 0.455 0.346 0.346 0.367 NA ...
  .. ..$ d_b                 : num [1:356] 0.333 0.25 0.25 0.267 NA ...
  .. ..$ d_hue               : chr [1:356] "7.5YR" "5YR" "5YR" "5YR" ...
  .. ..$ d_value             : num [1:356] 5 4 4 4 NA NA NA 4 4 4 ...
  .. ..$ d_chroma            : num [1:356] 4 4 4 4 NA NA NA 4 6 6 ...
  .. ..$ d_sigma             : num [1:356] NA NA NA 0.0144 NA ...
  .. ..$ m_r                 : num [1:356] 0.383 0.394 0.541 0.541 NA ...
  .. ..$ m_g                 : num [1:356] 0.257 0.25 0.331 0.331 NA ...
  .. ..$ m_b                 : num [1:356] 0.151 0.167 0.185 0.185 NA ...
  .. ..$ m_hue               : chr [1:356] "7.5YR" "5YR" "5YR" "5YR" ...
  .. ..$ m_value             : num [1:356] 3 3 4 4 NA NA NA 3 3 3 ...
  .. ..$ m_chroma            : num [1:356] 4 4 6 6 NA NA NA 4 4 4 ...
  .. ..$ m_sigma             : num [1:356] NA NA NA NA NA NA NA NA NA NA ...
  .. ..$ moist_soil_color    : chr [1:356] "#624126" "#64402B" "#8A542F" "#8A542F" ...
  .. ..$ dry_soil_color      : chr [1:356] "#987455" "#805840" "#805840" "#855D44" ...
  .. ..$ soil_color          : chr [1:356] "#624126" "#64402B" "#8A542F" "#8A542F" ...
  .. ..$ fine_gravel         : num [1:356] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ gravel              : num [1:356] 20 15 10 35 0 0 0 6 11 47 ...
  .. ..$ cobbles             : num [1:356] 20 10 10 50 0 0 0 0 0 11 ...
  .. ..$ stones              : num [1:356] 0 0 0 0 0 0 0 0 0 5 ...
  .. ..$ boulders            : num [1:356] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ channers            : num [1:356] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ flagstones          : num [1:356] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ parafine_gravel     : num [1:356] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ paragravel          : num [1:356] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ paracobbles         : num [1:356] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ parastones          : num [1:356] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ paraboulders        : num [1:356] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ parachanners        : num [1:356] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ paraflagstones      : num [1:356] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ unspecified         : num [1:356] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ total_frags_pct_nopf: num [1:356] 40 25 20 85 0 0 0 6 11 63 ...
  .. ..$ total_frags_pct     : num [1:356] 40 25 20 85 0 0 0 6 11 63 ...
  ..@ site      :'data.frame':	60 obs. of  83 variables:
  .. ..$ peiid               : chr [1:60] "207252" "242808" "252851" "268791" ...
  .. ..$ pedon_id            : chr [1:60] "06JCR005" "S2007CA009002" "S2007CA009002" "07JCR003" ...
  .. ..$ siteiid             : int [1:60] 209257 254491 254491 269602 269603 269604 269605 269606 307646 335626 ...
  .. ..$ site_id             : chr [1:60] "06CA630JCR005" "07-JCR-002" "07-JCR-002" "07CA630JCR003" ...
  .. ..$ obs_date            : POSIXct[1:60], format: "2006-08-21" "2007-04-02" "2007-04-02" "2007-05-14" ...
  .. ..$ utmzone             : int [1:60] 10 10 10 10 10 10 10 10 10 10 ...
  .. ..$ utmeasting          : num [1:60] 714807 700783 700783 714553 700765 ...
  .. ..$ utmnorthing         : num [1:60] 4195263 4201935 4201935 4191747 4201934 ...
  .. ..$ x                   : num [1:60] -121 -121 -121 -121 -121 ...
  .. ..$ y                   : num [1:60] 37.9 37.9 37.9 37.8 37.9 ...
  .. ..$ horizdatnm          : Factor w/ 25 levels "NAD27","NAD83",..: 2 2 2 2 2 2 2 2 2 2 ...
  .. ..$ x_std               : num [1:60] -121 -121 -121 -121 -121 ...
  .. ..$ y_std               : num [1:60] 37.9 37.9 37.9 37.8 37.9 ...
  .. ..$ gpspositionalerror  : num [1:60] NA NA NA NA NA NA NA NA NA NA ...
  .. ..$ describer           : chr [1:60] "John Rule" "John Rule" "John Rule" "John Rule" ...
  .. ..$ pedonpurpose        : Factor w/ 10 levels "crop yield data site",..: 4 8 4 4 4 4 4 4 2 4 ...
  .. ..$ pedontype           : Factor w/ 9 levels "map unit inclusion",..: 5 7 7 6 6 6 6 8 8 7 ...
  .. ..$ pedlabsampnum       : chr [1:60] NA "07N0469" "07N0469" NA ...
  .. ..$ labdatadescflag     : int [1:60] 0 1 0 0 0 0 0 0 0 0 ...
  .. ..$ elev_field          : num [1:60] 213 337 337 324 323 352 412 314 149 336 ...
  .. ..$ slope_field         : num [1:60] 47 20 20 15 20 38 31 22 NA 57 ...
  .. ..$ aspect_field        : int [1:60] 68 272 272 154 272 340 262 82 NA 135 ...
  .. ..$ plantassocnm        : chr [1:60] "Blue Oak Woodland" NA NA "Blue Oak Woodland" ...
  .. ..$ earthcovkind1       : Factor w/ 10 levels "artificial cover",..: NA NA NA NA NA NA NA NA NA NA ...
  .. ..$ earthcovkind2       : Factor w/ 28 levels "row crop","close-grown crop",..: NA NA NA NA NA NA NA NA NA NA ...
  .. ..$ erocl               : Factor w/ 5 levels "0","1","2","3",..: NA NA NA NA NA NA NA NA NA NA ...
  .. ..$ bedrckdepth         : int [1:60] 81 81 81 60 NA 91 NA 61 NA 91 ...
  .. ..$ bedrckkind          : Factor w/ 157 levels "sandstone, unspecified",..: 104 104 104 106 104 104 104 104 NA 106 ...
  .. ..$ bedrckhardness      : Factor w/ 14 levels "noncemented",..: 2 11 11 11 NA NA NA 11 NA 2 ...
  .. ..$ hillslopeprof       : Factor w/ 5 levels "summit","shoulder",..: 3 3 3 3 3 3 NA NA NA 3 ...
  .. ..$ geomslopeseg        : Factor w/ 9 levels "depression","drainageway",..: NA 4 4 NA NA NA NA NA NA NA ...
  .. ..$ shapeacross         : Factor w/ 5 levels "concave","linear",..: 3 2 2 3 2 2 NA 2 NA 3 ...
  .. ..$ shapedown           : Factor w/ 5 levels "concave","linear",..: 2 2 2 3 2 2 NA 2 NA 3 ...
  .. ..$ slopecomplex        : Factor w/ 2 levels "complex","simple": 2 1 1 NA 1 NA NA NA NA 2 ...
  .. ..$ drainagecl          : Factor w/ 8 levels "excessively",..: 3 3 3 3 3 3 3 3 NA 3 ...
  .. ..$ geomposhill         : Factor w/ 8 levels "interfluve","head slope",..: NA 4 4 4 4 4 NA 4 NA 4 ...
  .. ..$ geomposmntn         : Factor w/ 7 levels "mountaintop",..: NA NA NA NA NA NA NA NA NA NA ...
  .. ..$ geomposflats        : Factor w/ 4 levels "flat","dip","rise",..: NA NA NA NA NA NA NA NA NA NA ...
  .. ..$ slope_shape         : Factor w/ 9 levels "linear / convex",..: 5 2 2 4 2 2 NA 2 NA 4 ...
  .. ..$ classdate           : POSIXct[1:60], format: "2017-03-27 00:00:00" "2012-01-24 00:00:00" "2007-04-02 00:00:00" "2012-01-24 00:00:00" ...
  .. ..$ classifier          : chr [1:60] NA NA NA NA ...
  .. ..$ classtype           : Factor w/ 4 levels "correlated","field",..: 1 1 4 1 1 1 1 1 1 1 ...
  .. ..$ taxonname           : chr [1:60] "Gopheridge" "Gopheridge" "Gopheridge" "Gopheridge" ...
  .. ..$ localphase          : chr [1:60] NA NA NA NA ...
  .. ..$ taxonkind           : Factor w/ 6 levels "family","taxon above family",..: 4 4 NA 4 4 4 4 4 5 4 ...
  .. ..$ seriesstatus        : Factor w/ 3 levels "tentative","established",..: NA 1 NA NA NA NA NA NA 2 1 ...
  .. ..$ taxpartsize         : Factor w/ 113 levels "unclassified",..: 33 33 33 33 33 33 33 33 63 33 ...
  .. ..$ taxorder            : Factor w/ 12 levels "alfisols","andisols",..: 1 1 1 1 1 1 1 1 1 1 ...
  .. ..$ taxsuborder         : Factor w/ 81 levels "aqualfs","boralfs",..: 5 5 5 5 5 5 5 5 5 5 ...
  .. ..$ taxgrtgroup         : Factor w/ 459 levels "albaqualfs","duraqualfs",..: 38 38 38 38 38 38 38 38 38 38 ...
  .. ..$ taxsubgrp           : Factor w/ 3764 levels "typic albaqualfs",..: 270 270 266 270 270 270 270 270 270 270 ...
  .. ..$ soiltaxedition      : Factor w/ 12 levels "first edition",..: 12 10 10 10 12 10 10 12 12 12 ...
  .. ..$ osdtypelocflag      : int [1:60] 0 1 0 0 0 0 0 0 0 0 ...
  .. ..$ taxmoistcl          : Factor w/ 7 levels "aquic","aridic (torric)",..: 7 7 7 7 7 7 7 7 7 7 ...
  .. ..$ taxtempregime       : Factor w/ 13 levels "cryic","frigid",..: 10 10 10 10 10 10 10 10 10 10 ...
  .. ..$ taxfamother         : Factor w/ 13 levels "not used","coated",..: NA NA NA NA NA NA NA NA 6 NA ...
  .. ..$ psctopdepth         : int [1:60] NA 18 18 15 10 10 5 15 30 23 ...
  .. ..$ pscbotdepth         : int [1:60] NA 68 68 58 60 60 55 61 45 73 ...
  .. ..$ selection_method    : chr [1:60] "most recent" "most recent" "single record" "most recent" ...
  .. ..$ ecositeid           : chr [1:60] NA NA NA NA ...
  .. ..$ ecositenm           : chr [1:60] NA NA NA NA ...
  .. ..$ ecositecorrdate     : POSIXct[1:60], format: NA NA NA NA ...
  .. ..$ es_classifier       : chr [1:60] NA NA NA NA ...
  .. ..$ es_selection_method : chr [1:60] NA NA NA NA ...
  .. ..$ ochric.epipedon     : logi [1:60] TRUE TRUE TRUE TRUE TRUE TRUE ...
  .. ..$ argillic.horizon    : logi [1:60] TRUE TRUE TRUE TRUE TRUE TRUE ...
  .. ..$ lithic.contact      : logi [1:60] TRUE TRUE FALSE TRUE TRUE TRUE ...
  .. ..$ cambic.horizon      : logi [1:60] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ paralithic.contact  : logi [1:60] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ mollic.epipedon     : logi [1:60] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ paralithic.materials: logi [1:60] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ surface_fgravel     : num [1:60] 0 5 5 0 0 0 0 0 0 0 ...
  .. ..$ surface_gravel      : num [1:60] 0 11 11 0 5 5 0 5 0 5 ...
  .. ..$ surface_cobbles     : num [1:60] 0 1 1 0 0 0 0 0 0 3 ...
  .. ..$ surface_stones      : num [1:60] 0 0 0 0 0 0 0 0 0 2 ...
  .. ..$ surface_boulders    : num [1:60] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ surface_channers    : num [1:60] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ surface_flagstones  : num [1:60] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ surface_paragravel  : num [1:60] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ surface_paracobbles : num [1:60] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ landform_string     : chr [1:60] "canyon" "hillslope" "hillslope" "hillslope" ...
  .. ..$ pmkind              : chr [1:60] NA "colluvium & residuum" "colluvium & residuum" "colluvium & residuum" ...
  .. ..$ pmorigin            : chr [1:60] NA "greenstone" "greenstone" "metavolcanics" ...
  ..@ sp        :Formal class 'SpatialPoints' [package "sp"] with 3 slots
  .. .. ..@ coords     : num [1, 1] 0
  .. .. ..@ bbox       : logi [1, 1] NA
  .. .. ..@ proj4string:Formal class 'CRS' [package "sp"] with 1 slot
  .. .. .. .. ..@ projargs: chr NA
  ..@ diagnostic:'data.frame':	192 obs. of  4 variables:
  .. ..$ peiid   : int [1:192] 207252 207252 207252 242808 242808 242808 252851 252851 268791 268791 ...
  .. ..$ featkind: Factor w/ 84 levels "anthropic epipedon",..: 23 32 18 23 32 18 23 32 23 32 ...
  .. ..$ featdept: int [1:192] 0 18 81 0 18 81 5 18 0 15 ...
  .. ..$ featdepb: int [1:192] 18 81 152 18 81 NA 18 68 15 58 ...
}}

\examples{
\dontrun{
# load example dataset
data("gopheridge")

# what kind of object is this?
class(gopheridge)

# how many profiles?
length(gopheridge)

# there are 60 profiles, this calls for a split plot
par(mar=c(0,0,0,0), mfrow=c(2,1))

# plot soil colors
plot(gopheridge[1:30, ], name='hzname', color='soil_color')
plot(gopheridge[31:60, ], name='hzname', color='soil_color')

# need a larger top margin for legend
par(mar=c(0,0,4,0), mfrow=c(2,1))
# generate colors based on clay content
plot(gopheridge[1:30, ], name='hzname', color='clay')
plot(gopheridge[31:60, ], name='hzname', color='clay')

# single row and no labels
par(mar=c(0,0,0,0), mfrow=c(1,1))
# plot soils sorted by depth to contact
plot(gopheridge, name='', print.id=FALSE, plot.order=order(gopheridge$bedrckdepth))

# plot first 10 profiles
plot(gopheridge[1:10, ], name='hzname', color='soil_color', label='pedon_id', id.style='side')

# add rock fragment data to plot:
addVolumeFraction(gopheridge[1:10, ], colname='total_frags_pct')

# add diagnostic horizons
addDiagnosticBracket(gopheridge[1:10, ], kind='argillic horizon', col='red', offset=-0.4)

## loafercreek
data("loafercreek")
# plot first 10 profiles
plot(loafercreek[1:10, ], name='hzname', color='soil_color', label='pedon_id', id.style='side')

# add rock fragment data to plot:
addVolumeFraction(loafercreek[1:10, ], colname='total_frags_pct')

# add diagnostic horizons
addDiagnosticBracket(loafercreek[1:10, ], kind='argillic horizon', col='red', offset=-0.4)
}
}


\keyword{datasets}
