% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_component_data_from_NASIS_db.R
\name{get_component_data_from_NASIS_db}
\alias{get_component_data_from_NASIS_db}
\alias{get_component_diaghz_from_NASIS_db}
\alias{get_component_restrictions_from_NASIS_db}
\alias{get_component_correlation_data_from_NASIS_db}
\alias{get_component_cogeomorph_data_from_NASIS_db}
\alias{get_component_cogeomorph_data_from_NASIS_db2}
\alias{get_component_copm_data_from_NASIS_db}
\alias{get_component_esd_data_from_NASIS_db}
\alias{get_component_otherveg_data_from_NASIS_db}
\alias{get_copedon_from_NASIS_db}
\alias{get_component_horizon_data_from_NASIS_db}
\title{Get component data from a local NASIS Database}
\usage{
get_component_data_from_NASIS_db(
  SS = TRUE,
  nullFragsAreZero = TRUE,
  stringsAsFactors = default.stringsAsFactors(),
  dsn = NULL
)

get_component_diaghz_from_NASIS_db(SS = TRUE, dsn = NULL)

get_component_restrictions_from_NASIS_db(SS = TRUE, dsn = NULL)

get_component_correlation_data_from_NASIS_db(
  SS = TRUE,
  dropAdditional = TRUE,
  dropNotRepresentative = TRUE,
  stringsAsFactors = default.stringsAsFactors(),
  dsn = NULL
)

get_component_cogeomorph_data_from_NASIS_db(SS = TRUE, dsn = NULL)

get_component_cogeomorph_data_from_NASIS_db2(SS = TRUE, dsn = NULL)

get_component_copm_data_from_NASIS_db(
  SS = TRUE,
  stringsAsFactors = default.stringsAsFactors(),
  dsn = NULL
)

get_component_esd_data_from_NASIS_db(
  SS = TRUE,
  stringsAsFactors = default.stringsAsFactors(),
  dsn = NULL
)

get_component_otherveg_data_from_NASIS_db(SS = TRUE, dsn = NULL)

get_copedon_from_NASIS_db(SS = TRUE, dsn = NULL)

get_component_horizon_data_from_NASIS_db(
  SS = TRUE,
  fill = FALSE,
  dsn = NULL,
  nullFragsAreZero = TRUE
)
}
\arguments{
\item{SS}{fetch data from the currently loaded selected set in NASIS or from
the entire local database (default: \code{TRUE})}

\item{nullFragsAreZero}{should surface fragment cover percentages of NULL be interpreted as 0? (default: TRUE)}

\item{stringsAsFactors}{logical: should character vectors be converted to
factors? This argument is passed to the \code{uncode()} function. It does not
convert those vectors that have set outside of \code{uncode()} (i.e. hard coded).
The 'factory-fresh' default is TRUE, but this can be changed by setting
options(\code{stringsAsFactors = FALSE})}

\item{dsn}{Optional: path to local SQLite database containing NASIS
table structure; default: \code{NULL}}

\item{dropAdditional}{Remove map units with "additional" status? Default: \code{TRUE}}

\item{dropNotRepresentative}{Remove non-representative data map units? Default: \code{TRUE}}

\item{fill}{Return a single minimal (NA-filled) horizon for components with no horizon records? Default \code{FALSE}}
}
\value{
a \code{data.frame}
}
\description{
Get component data from a local NASIS Database
}
\examples{

\donttest{
if(local_NASIS_defined()) {
 # query text note data
 fc <- try(get_component_data_from_NASIS_db())

 # show structure of component data returned
 str(fc)
}
}

}
\seealso{
\code{\link{fetchNASIS}}
}
\author{
Dylan E. Beaudette, Stephen Roecker, and Jay M. Skovlin
}
\keyword{manip}
