% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothContours.R
\name{getSmoothContour}
\alias{getSmoothContour}
\title{Smooth contour from anchors}
\usage{
getSmoothContour(anchors = data.frame(time = c(0, 1), value = c(0, 1)),
  len = NULL, thisIsPitch = FALSE, method = c("spline", "loess")[2],
  valueFloor = NULL, valueCeiling = NULL, plot = FALSE, main = "",
  xlim = NULL, ylim = NULL, samplingRate = 16000, voiced = NULL,
  contourLabel = NULL, ...)
}
\arguments{
\item{anchors}{a dataframe of anchors with specified time and amplitude.
\code{achors$time} can be in ms (with len=NULL) or in arbitrary units, eg 0
to 1 (with duration determined by len, which must then be provided in ms).
So anchors$time is assumed to be in ms if len=NULL and relative if len is
specified. \code{anchors$value} can be on any scale.}

\item{len}{the required length of the output contour. If NULL, it will be
calculated based on the maximum time value (in ms) and \code{samplingRate}}

\item{thisIsPitch}{(boolean) is this a pitch contour? If true, log-transforms
before smoothing and plots in both Hz and musical notation}

\item{method}{smoothing method: 'spline' or 'loess' (default). Consider
'spline' if you have a lot of anchors and not much patience, since it is
much faster than 'loess', but it may produce weird results when there are
only a few anchors}

\item{valueFloor, valueCeiling}{lower/upper bounds for the contour}

\item{plot}{(boolean) produce a plot?}

\item{main, xlim, ylim}{plotting options}

\item{samplingRate}{sampling rate used to convert time values to points (Hz)}

\item{voiced, contourLabel}{graphical pars for plotting breathing contours
(see examples below)}

\item{...}{other plotting options passed to \code{plot()}}
}
\value{
Returns a numeric vector.
}
\description{
Returns a smooth contour based on an arbitrary number of anchors. Used by
\code{\link{soundgen}} for generating intonation contour, mouth opening, etc.
Note that pitch contours are treated as a special case: values are
log-transformed prior to smoothing, so that with 2 anchors we get a linear
transition on a log scale (as if we were operating with musical notes rather
than frequencies in Hz). Pitch plots have two Y axes: one showing Hz and the
other showing musical notation.
}
\examples{
# long format: anchors are a dataframe
a = getSmoothContour(anchors = data.frame(
  time = c(50, 137, 300), value = c(0.03, 0.78, 0.5)),
  voiced = 200, valueFloor = 0, plot = TRUE, main = '',
  samplingRate = 16000) # breathing

# short format: anchors are a vector (equal time steps assumed)
a = getSmoothContour(anchors = c(350, 800, 600),
  len = 5500, thisIsPitch = TRUE, plot = TRUE,
  samplingRate = 3500) # pitch

# a single anchor gives constant value
a = getSmoothContour(anchors = 800,
  len = 500, thisIsPitch = TRUE, plot = TRUE, samplingRate = 500)

# two pitch anchors give loglinear F0 change
a = getSmoothContour(anchors = c(220, 440),
  len = 500, thisIsPitch = TRUE, plot = TRUE, samplingRate = 500)
}
