% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{analyzeFolder}
\alias{analyzeFolder}
\title{Analyze folder}
\usage{
analyzeFolder(myfolder, htmlPlots = TRUE, verbose = TRUE,
  samplingRate = NULL, dynamicRange = 80, silence = 0.04,
  SPL_measured = 70, Pref = 20, windowLength = 50, step = NULL,
  overlap = 50, wn = "gaussian", zp = 0, cutFreq = 6000,
  nFormants = 3, pitchMethods = c("autocor", "spec", "dom"),
  entropyThres = 0.6, pitchFloor = 75, pitchCeiling = 3500,
  priorMean = HzToSemitones(300), priorSD = 6, priorPlot = FALSE,
  nCands = 1, minVoicedCands = "autom", domThres = 0.1,
  domSmooth = 220, autocorThres = 0.7, autocorSmooth = NULL,
  cepThres = 0.3, cepSmooth = NULL, cepZp = 0, specThres = 0.3,
  specPeak = 0.35, specSinglePeakCert = 0.4, specHNRslope = 0.8,
  specSmooth = 150, specMerge = 1, shortestSyl = 20,
  shortestPause = 60, interpolWin = 3, interpolTol = 0.3,
  interpolCert = 0.3, pathfinding = c("none", "fast", "slow")[2],
  annealPars = list(maxit = 5000, temp = 1000), certWeight = 0.5,
  snakeStep = 0.05, snakePlot = FALSE, smooth = 1,
  smoothVars = c("pitch", "dom"), summary = TRUE,
  summaryStats = c("mean", "median", "sd"), plot = FALSE,
  showLegend = TRUE, savePlots = FALSE, plotSpec = TRUE,
  pitchPlot = list(col = rgb(0, 0, 1, 0.75), lwd = 3),
  candPlot = list(levels = c("autocor", "spec", "dom", "cep"), col =
  c("green", "red", "orange", "violet"), pch = c(16, 2, 3, 7), cex = 2),
  ylim = NULL, xlab = "Time, ms", ylab = "kHz", main = NULL,
  width = 900, height = 500, units = "px", res = NA, ...)
}
\arguments{
\item{myfolder}{full path to target folder}

\item{htmlPlots}{if TRUE, saves an html file with clickable plots}

\item{verbose}{if TRUE, reports progress and estimated time left}

\item{samplingRate}{sampling rate of \code{x} (only needed if
\code{x} is a numeric vector, rather than an audio file)}

\item{dynamicRange}{dynamic range, dB. All values more than one dynamicRange
under maximum are treated as zero}

\item{silence}{(0 to 1) frames with RMS amplitude below silence threshold are
not analyzed at all. NB: this number is dynamically updated: the actual
silence threshold may be higher depending on the quietest frame, but it
will never be lower than this specified number.}

\item{SPL_measured}{sound pressure level at which the sound is presented, dB}

\item{Pref}{reference pressure, Pa}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{wn}{window type: gaussian, hanning, hamming, bartlett, rectangular,
blackman, flattop}

\item{zp}{window length after zero padding, points}

\item{cutFreq}{(>0 to Nyquist, Hz) repeat the calculation of spectral
descriptives after discarding all info above \code{cutFreq}.
Recommended if the original sampling rate varies across different analyzed
audio files}

\item{nFormants}{the number of formants to extract per FFT frame. Calls
\code{\link[phonTools]{findformants}} with default settings}

\item{pitchMethods}{methods of pitch estimation to consider for determining
pitch contour: 'autocor' = autocorrelation (~PRAAT), 'cep' = cepstral,
'spec' = spectral (~BaNa), 'dom' = lowest dominant frequency band}

\item{entropyThres}{pitch tracking is not performed for frames with Weiner
entropy above \code{entropyThres}, but other spectral descriptives are
still calculated}

\item{pitchFloor}{absolute bounds for pitch candidates (Hz)}

\item{pitchCeiling}{absolute bounds for pitch candidates (Hz)}

\item{priorMean}{specifies the mean and sd of gamma distribution
describing our prior knowledge about the most likely pitch values for this
file. Specified in semitones: \code{priorMean = HzToSemitones(300),
priorSD = 6} gives a prior with mean = 300 Hz and SD of 6 semitones (half
an octave)}

\item{priorSD}{specifies the mean and sd of gamma distribution
describing our prior knowledge about the most likely pitch values for this
file. Specified in semitones: \code{priorMean = HzToSemitones(300),
priorSD = 6} gives a prior with mean = 300 Hz and SD of 6 semitones (half
an octave)}

\item{priorPlot}{if TRUE, produces a separate plot of the prior}

\item{nCands}{maximum number of pitch candidates per method (except for
\code{dom}, which returns at most one candidate per frame), normally 1...4}

\item{minVoicedCands}{minimum number of pitch candidates that
have to be defined to consider a frame voiced (defaults to 2 if \code{dom}
is among other candidates and 1 otherwise)}

\item{domThres}{(0 to 1) to find the lowest dominant frequency band, we
do short-term FFT and take the lowest frequency with amplitude at least
domThres}

\item{domSmooth}{the width of smoothing interval (Hz) for finding
\code{dom}}

\item{autocorThres}{(0 to 1) separate
voicing thresholds for detecting pitch candidates with three different
methods: autocorrelation, cepstrum, and BaNa algorithm (see Details). Note
that HNR is calculated even for unvoiced frames.}

\item{autocorSmooth}{the width of smoothing interval (in bins) for
finding peaks in the autocorrelation function. Defaults to 7 for sampling
rate 44100 and smaller odd numbers for lower values of sampling rate}

\item{cepThres}{(0 to 1) separate
voicing thresholds for detecting pitch candidates with three different
methods: autocorrelation, cepstrum, and BaNa algorithm (see Details). Note
that HNR is calculated even for unvoiced frames.}

\item{cepSmooth}{the width of smoothing interval (in bins) for finding
peaks in the cepstrum. Defaults to 31 for sampling rate 44100 and smaller
odd numbers for lower values of sampling rate}

\item{cepZp}{zero-padding of the spectrum used for cepstral pitch detection
(final length of spectrum after zero-padding in points, e.g. 2 ^ 13)}

\item{specThres}{(0 to 1) separate
voicing thresholds for detecting pitch candidates with three different
methods: autocorrelation, cepstrum, and BaNa algorithm (see Details). Note
that HNR is calculated even for unvoiced frames.}

\item{specPeak}{when looking for putative harmonics in
the spectrum, the threshold for peak detection is calculated as
\code{specPeak * (1 - HNR * specHNRslope)}}

\item{specSinglePeakCert}{(0 to 1) if F0 is calculated based on a single
harmonic ratio (as opposed to several ratios converging on the same
candidate), its certainty is taken to be \code{specSinglePeakCert}}

\item{specHNRslope}{when looking for putative harmonics in
the spectrum, the threshold for peak detection is calculated as
\code{specPeak * (1 - HNR * specHNRslope)}}

\item{specSmooth}{the width of window for detecting peaks in the spectrum, Hz}

\item{specMerge}{pitch candidates within \code{specMerge} semitones are
merged with boosted certainty}

\item{shortestSyl}{the smallest length of a voiced segment (ms) that
constitutes a voiced syllable (shorter segments will be replaced by NA, as
if unvoiced)}

\item{shortestPause}{the smallest gap between voiced syllables (ms) that
means they shouldn't be merged into one voiced syllable}

\item{interpolWin}{control the behavior of
interpolation algorithm when postprocessing pitch candidates. To turn off
interpolation, set \code{interpolWin} to NULL. See
\code{soundgen:::pathfinder} for details.}

\item{interpolTol}{control the behavior of
interpolation algorithm when postprocessing pitch candidates. To turn off
interpolation, set \code{interpolWin} to NULL. See
\code{soundgen:::pathfinder} for details.}

\item{interpolCert}{control the behavior of
interpolation algorithm when postprocessing pitch candidates. To turn off
interpolation, set \code{interpolWin} to NULL. See
\code{soundgen:::pathfinder} for details.}

\item{pathfinding}{method of finding the optimal path through pitch
candidates: 'none' = best candidate per frame, 'fast' = simple heuristic,
'slow' = annealing. See \code{soundgen:::pathfinder}}

\item{annealPars}{a list of control parameters for postprocessing of
pitch contour with SANN algorithm of \code{\link[stats]{optim}}. This is
only relevant if \code{pathfinding = 'slow'}}

\item{certWeight}{(0 to 1) in pitch postprocessing, specifies how much we
prioritize the certainty of pitch candidates vs. pitch jumps / the internal
tension of the resulting pitch curve}

\item{snakeStep}{optimized path through pitch candidates is further
processed to minimize the elastic force acting on pitch contour. To
disable, set \code{snakeStep} to NULL}

\item{snakePlot}{if TRUE, plots the snake}

\item{smooth}{if \code{smooth} is a positive number, outliers of
the variables in \code{smoothVars} are adjusted with median smoothing.
\code{smooth} of 1 corresponds to a window of ~100 ms and tolerated
deviation of ~4 semitones. To disable, set \code{smooth} to NULL}

\item{smoothVars}{if \code{smooth} is a positive number, outliers of
the variables in \code{smoothVars} are adjusted with median smoothing.
\code{smooth} of 1 corresponds to a window of ~100 ms and tolerated
deviation of ~4 semitones. To disable, set \code{smooth} to NULL}

\item{summary}{if TRUE, returns only a summary of the measured acoustic
variables (mean, median and SD). If FALSE, returns a list containing
frame-by-frame values}

\item{summaryStats}{a vector of names of functions used to summarize each
acoustic characteristic}

\item{plot}{if TRUE, produces a spectrogram with pitch contour overlaid}

\item{showLegend}{if TRUE, adds a legend with pitch tracking methods}

\item{savePlots}{if TRUE, saves plots as .png files}

\item{plotSpec}{if \code{FALSE}, the spectrogram will not be plotted}

\item{pitchPlot}{a list of graphical parameters for displaying the final
pitch contour. Set to \code{NULL} or \code{NA} to suppress}

\item{candPlot}{a list of graphical parameters for displaying
individual pitch candidates. Set to \code{NULL} or \code{NA} to suppress}

\item{ylim}{frequency range to plot, kHz (defaults to 0 to Nyquist frequency)}

\item{xlab}{plotting parameters}

\item{ylab}{plotting parameters}

\item{main}{plotting parameters}

\item{width}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{height}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{units}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{res}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{...}{other graphical parameters passed to \code{\link{spectrogram}}}
}
\value{
If \code{summary} is TRUE, returns a dataframe with one row per audio
  file. If \code{summary} is FALSE, returns a list of detailed descriptives.
}
\description{
Acoustic analysis of all .wav files in a folder. See \code{\link{analyze}}
and vignette('acoustic_analysis', package = 'soundgen') for further details.
}
\examples{
\dontrun{
# download 260 sounds from Anikin & Persson (2017)
# http://cogsci.se/personal/results/
# 01_anikin-persson_2016_naturalistics-non-linguistic-vocalizations/260sounds_wav.zip
# unzip them into a folder, say '~/Downloads/temp'
myfolder = '~/Downloads/temp'  # 260 .wav files live here
s = analyzeFolder(myfolder, verbose = TRUE)  # ~ 15-30 minutes!

# Save spectrograms with pitch contours plus an html file for easy access
a = analyzeFolder('~/Downloads/temp', savePlots = TRUE,
  showLegend = TRUE,
  width = 20, height = 12,
  units = 'cm', res = 300)

# Check accuracy: import manually verified pitch values (our "key")
key = pitchManual  # a vector of 260 floats
trial = s$pitch_median
cor(key, trial, use = 'pairwise.complete.obs')
plot(log(key), log(trial))
abline(a=0, b=1, col='red')
}
}
