% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_irf.R
\name{rvar_irf}
\alias{rvar_irf}
\title{Estimate regime-dependent impulse response functions}
\usage{
rvar_irf(rvar, horizon = 10, bootstraps.num = 100, CI = c(0.1, 0.9))
}
\arguments{
\item{rvar}{RVAR output}

\item{horizon}{int: number of periods}

\item{bootstraps.num}{int: number of bootstraps}

\item{CI}{numeric vector: c(lower ci bound, upper ci bound)}
}
\value{
list of lists, each regime returns its own list with elements \code{irfs}, \code{ci.lower}, and \code{ci.upper}; all elements are long-form data.frames
}
\description{
Estimate impulse responses with contemporaneous impact restrictions via Cholesky decomposition -
taking the variable ordering present in the VAR object. Estimate one response function per unique
state defined by the regime-dependent VAR.
}
\examples{
\donttest{

 # simple time series
 AA = c(1:100) + rnorm(100)
 BB = c(1:100) + rnorm(100)
 CC = AA + BB + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, AA, BB, CC)
 Data = dplyr::mutate(Data, reg = dplyr::if_else(AA > median(AA), 1, 0))

 # estimate VAR
  rvar =
    sovereign::RVAR(
      data = Data,
      horizon = 10,
      freq = 'month',
      regime.method = 'rf',
      regime.n = 2,
      lag.ic = 'BIC',
      lag.max = 4)

# impulse response functions
rvar.irf = sovereign::rvar_irf(rvar)

# forecast error variance decomposition
rvar.fevd = sovereign::rvar_fevd(rvar)

# historical shock decomposition
rvar.hd = sovereign::rvar_hd(rvar)

}

}
\seealso{
\code{\link[=VAR]{VAR()}}

\code{\link[=var_irf]{var_irf()}}

\code{\link[=var_fevd]{var_fevd()}}

\code{\link[=RVAR]{RVAR()}}

\code{\link[=rvar_irf]{rvar_irf()}}

\code{\link[=rvar_fevd]{rvar_fevd()}}
}
