% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{LP}
\alias{LP}
\title{Estimate local projections}
\usage{
LP(
  data,
  horizons = 1,
  freq = "month",
  type = "const",
  p = 1,
  lag.ic = NULL,
  lag.max = NULL,
  NW = FALSE,
  NW_lags = NULL,
  NW_prewhite = NULL
)
}
\arguments{
\item{data}{data.frame, matrix, ts, xts, zoo: Endogenous regressors}

\item{horizons}{int: forecast horizons}

\item{freq}{string: frequency of data ('day', 'week', 'month', 'quarter', or 'year')}

\item{type}{string: type of deterministic terms to add ('none', 'const', 'trend', or 'both')}

\item{p}{int: lags}

\item{lag.ic}{string: information criterion to choose the optimal number of lags ('AIC' or 'BIC')}

\item{lag.max}{int: maximum number of lags to test in lag selection}

\item{NW}{boolean: Newey-West correction on variance-covariance matrix}

\item{NW_lags}{int: number of lags to use in Newey-West correction}

\item{NW_prewhite}{boolean: TRUE prewhite option for Newey-West correction (see sandwich::NeweyWest)}
}
\value{
list object with elements \code{data}, \code{model}, \code{forecasts}, \code{residuals}; if there is more than one forecast horizon estimated, then \code{model}, \code{forecasts}, \code{residuals} will each be a list where each element corresponds to a single horizon
}
\description{
Estimate local projections
}
\examples{
\donttest{

  # simple time series
  AA = c(1:100) + rnorm(100)
  BB = c(1:100) + rnorm(100)
  CC = AA + BB + rnorm(100)
  date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
  Data = data.frame(date = date, AA, BB, CC)

  # local projection forecasts
  lp =
    sovereign::LP(
      data = Data,
      horizon = c(1:10),
      lag.ic = 'AIC',
      lag.max = 4,
      type =  'both',
      freq = 'month')

  # impulse response function
  irf = sovereign::lp_irf(lp)

}

}
\references{
\enumerate{
\item Jorda, Oscar "\href{https://www.aeaweb.org/articles?id=10.1257/0002828053828518}{Estimation and Inference of Impulse Responses by Local Projections}" 2005.
}
}
\seealso{
\code{\link[=LP]{LP()}}

\code{\link[=lp_irf]{lp_irf()}}

\code{\link[=RLP]{RLP()}}

\code{\link[=rlp_irf]{rlp_irf()}}
}
