% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcmc.R
\name{gcmc}
\alias{gcmc}
\alias{gcmc,sf-method}
\alias{gcmc,SpatRaster-method}
\title{geographical cross mapping cardinality}
\usage{
\S4method{gcmc}{sf}(
  data,
  cause,
  effect,
  E = 3,
  tau = 1,
  k = NULL,
  r = 0,
  lib = NULL,
  pred = NULL,
  nb = NULL,
  threads = detectThreads(),
  bidirectional = TRUE,
  trend.rm = TRUE,
  progressbar = TRUE
)

\S4method{gcmc}{SpatRaster}(
  data,
  cause,
  effect,
  E = 3,
  tau = 1,
  k = NULL,
  r = 0,
  lib = NULL,
  pred = NULL,
  threads = detectThreads(),
  bidirectional = TRUE,
  trend.rm = TRUE,
  progressbar = TRUE
)
}
\arguments{
\item{data}{The observation data.}

\item{cause}{Name of causal variable.}

\item{effect}{Name of effect variable.}

\item{E}{(optional) Dimensions of the embedding.}

\item{tau}{(optional) Step of spatial lags.}

\item{k}{(optional) Number of nearest neighbors used in intersection.}

\item{r}{(optional) Number of excluded neighbors in intersection.}

\item{lib}{(optional) Libraries indices.}

\item{pred}{(optional) Predictions indices.}

\item{nb}{(optional) The neighbours list.}

\item{threads}{(optional) Number of threads.}

\item{bidirectional}{(optional) whether to examine bidirectional causality.}

\item{trend.rm}{(optional) Whether to remove the linear trend.}

\item{progressbar}{(optional) whether to show the progress bar.}
}
\value{
A list
\describe{
\item{\code{xmap}}{cross mapping results}
\item{\code{varname}}{names of causal and effect variable}
\item{\code{bidirectional}}{whether to examine bidirectional causality}
}
}
\description{
geographical cross mapping cardinality
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
\donttest{
g = gcmc(columbus,"hoval","crime",E = 5)
g
}
}
