% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entity-functions.R
\name{entity_extract}
\alias{entity_extract}
\alias{entity_consolidate}
\title{Extract or consolidate entities from parsed documents}
\usage{
entity_extract(x, type = c("named", "extended", "all"))

entity_consolidate(x, concatenator = "_")
}
\arguments{
\item{x}{output from \code{\link{spacy_parse}}.}

\item{type}{type of named entities, either \code{named}, \code{extended}, or 
\code{all}.  See 
\url{https://spacy.io/docs/usage/entity-recognition#entity-types} for 
details.}

\item{concatenator}{the character used to concatenator elements of multi-word
named entities}
}
\value{
\code{entity_extract} returns a \code{data.frame} of all named
  entities, containing the following fields: 
  \itemize{
  \item{\code{doc_id}}{ name of the documument containing the entity} 
  \item{\code{sentence_id}}{ the sentence ID containing the entity, within the document}
  \item{\code{entity}}{ the named entity}
  \item{\code{entity_type}}{ type of named entities (e.g. PERSON, ORG, PERCENT,
  etc.)} 
  }

\code{entity_consolidate} returns a modified \code{data.frame} of
  parsed results, where the named entities have been combined into a single
  "token".  Currently, dependency parsing is removed when this consolidation
  occurs.
}
\description{
From an object parsed by \code{\link{spacy_parse}}, extract the entities as a
separate object, or convert the multi-word entities into single "token"
consisting of the concatenated elements of the multi-word entities.
}
\examples{
\donttest{
spacy_initialize()

# entity extraction
txt <- "Mr. Smith of moved to San Francisco in December."
parsed <- spacy_parse(txt, entity = TRUE)
entity_extract(parsed)
entity_extract(parsed, type = "all")
}
\donttest{
# consolidating multi-word entities 
txt <- "The House of Representatives voted to suspend aid to South Dakota."
parsed <- spacy_parse(txt, entity = TRUE)
entity_consolidate(parsed)
}
}
