% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_generalized_linear_regression.R
\name{ml_generalized_linear_regression}
\alias{ml_generalized_linear_regression}
\title{Spark ML -- Generalized Linear Regression}
\usage{
ml_generalized_linear_regression(x, response, features, intercept = TRUE,
  family = gaussian(link = "identity"), iter.max = 100L,
  ml.options = ml_options(), ...)
}
\arguments{
\item{x}{An object coercable to a Spark DataFrame (typically, a
\code{tbl_spark}).}

\item{response}{The name of the response vector (as a length-one character
vector), or a formula, giving a symbolic description of the model to be
fitted. When \code{response} is a formula, it is used in preference to other
parameters to set the \code{response}, \code{features}, and \code{intercept}
parameters (if available). Currently, only simple linear combinations of
existing parameters is supposed; e.g. \code{response ~ feature1 + feature2 + ...}.
The intercept term can be omitted by using \code{- 1} in the model fit.}

\item{features}{The name of features (terms) to use for the model fit.}

\item{intercept}{Boolean; should the model be fit with an intercept term?}

\item{family}{The family / link function to use; analogous to those normally
passed in to calls to \R's own \code{\link{glm}}.}

\item{iter.max}{The maximum number of iterations to use.}

\item{ml.options}{Optional arguments, used to affect the model generated. See
\code{\link{ml_options}} for more details.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Perform generalized linear regression on a Spark DataFrame.
}
\details{
In contrast to \code{\link{ml_linear_regression}()} and
\code{\link{ml_logistic_regression}()}, these routines do not allow you to
tweak the loss function (e.g. for elastic net regression); however, the model
fits returned by this routine are generally richer in regards to information
provided for assessing the quality of fit.
}
\seealso{
Other Spark ML routines: \code{\link{ml_als_factorization}},
  \code{\link{ml_decision_tree}},
  \code{\link{ml_gradient_boosted_trees}},
  \code{\link{ml_kmeans}}, \code{\link{ml_lda}},
  \code{\link{ml_linear_regression}},
  \code{\link{ml_logistic_regression}},
  \code{\link{ml_multilayer_perceptron}},
  \code{\link{ml_naive_bayes}},
  \code{\link{ml_one_vs_rest}}, \code{\link{ml_pca}},
  \code{\link{ml_random_forest}},
  \code{\link{ml_survival_regression}}
}

