% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_survival_regression.R
\name{ml_survival_regression}
\alias{ml_survival_regression}
\title{Spark ML -- Survival Regression}
\usage{
ml_survival_regression(x, response, features, intercept = TRUE,
  censor = "censor", iter.max = 100L, ml.options = ml_options(), ...)
}
\arguments{
\item{x}{An object coercable to a Spark DataFrame (typically, a
\code{tbl_spark}).}

\item{response}{The name of the response vector (as a length-one character
vector), or a formula, giving a symbolic description of the model to be
fitted. When \code{response} is a formula, it is used in preference to other
parameters to set the \code{response}, \code{features}, and \code{intercept}
parameters (if available). Currently, only simple linear combinations of
existing parameters is supposed; e.g. \code{response ~ feature1 + feature2 + ...}.
The intercept term can be omitted by using \code{- 1} in the model fit.}

\item{features}{The name of features (terms) to use for the model fit.}

\item{intercept}{Boolean; should the model be fit with an intercept term?}

\item{censor}{The name of the vector that provides censoring information.
This should be a numeric vector, with 0 marking uncensored data, and
1 marking right-censored data.}

\item{iter.max}{The maximum number of iterations to use.}

\item{ml.options}{Optional arguments, used to affect the model generated. See
\code{\link{ml_options}} for more details.}

\item{...}{Optional arguments. The \code{data} argument can be used to
specify the data to be used when \code{x} is a formula; this allows calls
of the form \code{ml_linear_regression(y ~ x, data = tbl)}, and is
especially useful in conjunction with \code{\link{do}}.}
}
\description{
Perform survival regression on a Spark DataFrame, using an Accelerated
failure time (AFT) model with potentially right-censored data.
}
\seealso{
Other Spark ML routines: \code{\link{ml_als_factorization}},
  \code{\link{ml_decision_tree}},
  \code{\link{ml_generalized_linear_regression}},
  \code{\link{ml_gradient_boosted_trees}},
  \code{\link{ml_kmeans}}, \code{\link{ml_lda}},
  \code{\link{ml_linear_regression}},
  \code{\link{ml_logistic_regression}},
  \code{\link{ml_multilayer_perceptron}},
  \code{\link{ml_naive_bayes}},
  \code{\link{ml_one_vs_rest}}, \code{\link{ml_pca}},
  \code{\link{ml_random_forest}}
}
\concept{Spark ML routines}
