/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.input;

import com.univocity.parsers.common.input.CharAppender;
import java.util.Arrays;

public class DefaultCharAppender
implements CharAppender {
    final char[] emptyChars;
    final char[] chars;
    final char padding;
    int index = 0;
    final String emptyValue;
    int whitespaceCount = 0;

    public DefaultCharAppender(int maxLength, String emptyValue) {
        this(maxLength, emptyValue, ' ');
    }

    public DefaultCharAppender(int maxLength, String emptyValue, char padding) {
        this.chars = new char[maxLength];
        this.emptyValue = emptyValue;
        this.padding = padding;
        this.emptyChars = (char[])(emptyValue == null ? null : emptyValue.toCharArray());
    }

    @Override
    public void appendIgnoringWhitespaceAndPadding(char ch) {
        this.whitespaceCount = ch <= ' ' || ch == this.padding ? ++this.whitespaceCount : 0;
        this.chars[this.index++] = ch;
    }

    @Override
    public void appendIgnoringPadding(char ch) {
        this.whitespaceCount = ch == this.padding ? ++this.whitespaceCount : 0;
        this.chars[this.index++] = ch;
    }

    @Override
    public void appendIgnoringWhitespace(char ch) {
        this.whitespaceCount = ch <= ' ' ? ++this.whitespaceCount : 0;
        this.chars[this.index++] = ch;
    }

    @Override
    public void append(char ch) {
        this.chars[this.index++] = ch;
    }

    @Override
    public String getAndReset() {
        String out = this.emptyValue;
        if (this.index > this.whitespaceCount) {
            out = new String(this.chars, 0, this.index - this.whitespaceCount);
        }
        this.index = 0;
        this.whitespaceCount = 0;
        return out;
    }

    public String toString() {
        if (this.index <= this.whitespaceCount) {
            return this.emptyValue;
        }
        return new String(this.chars, 0, this.index - this.whitespaceCount);
    }

    @Override
    public int length() {
        return this.index - this.whitespaceCount;
    }

    @Override
    public char[] getCharsAndReset() {
        char[] out = this.emptyChars;
        if (this.index > this.whitespaceCount) {
            out = Arrays.copyOf(this.chars, this.index - this.whitespaceCount);
        }
        this.index = 0;
        this.whitespaceCount = 0;
        return out;
    }

    @Override
    public int whitespaceCount() {
        return this.whitespaceCount;
    }

    @Override
    public void reset() {
        this.index = 0;
        this.whitespaceCount = 0;
    }

    public void append(DefaultCharAppender appender) {
        System.arraycopy(appender.chars, 0, this.chars, this.index, appender.index - appender.whitespaceCount);
        this.index += appender.index - appender.whitespaceCount;
        appender.reset();
    }

    @Override
    public void resetWhitespaceCount() {
        this.whitespaceCount = 0;
    }

    @Override
    public char[] getChars() {
        return this.chars;
    }
}

