% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_data.R
\name{stream_read_parquet}
\alias{stream_read_parquet}
\title{Read Parquet Stream}
\usage{
stream_read_parquet(sc, path, name = NULL, columns = NULL,
  options = list(), ...)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3a://"} and \samp{"file://"} protocols.}

\item{name}{The name to assign to the newly generated stream.}

\item{columns}{A vector of column names or a named vector of column types.}

\item{options}{A list of strings with additional options.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Reads a parquet stream as a Spark dataframe stream.
}
\seealso{
Other Spark stream serialization: \code{\link{stream_read_csv}},
  \code{\link{stream_read_json}},
  \code{\link{stream_read_kafka}},
  \code{\link{stream_read_orc}},
  \code{\link{stream_read_text}},
  \code{\link{stream_write_csv}},
  \code{\link{stream_write_json}},
  \code{\link{stream_write_kafka}},
  \code{\link{stream_write_memory}},
  \code{\link{stream_write_orc}},
  \code{\link{stream_write_parquet}},
  \code{\link{stream_write_text}}
}
\concept{Spark stream serialization}
