/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import sparklyr.WeightedQuantileSummaries;

public final class WeightedQuantileSummaries$
implements scala.Serializable {
    public static WeightedQuantileSummaries$ MODULE$;
    private final int defaultCompressThreshold;
    private final int defaultBufferSize;
    private final double defaultRelativeError;

    static {
        new WeightedQuantileSummaries$();
    }

    public WeightedQuantileSummaries.Stats[] $lessinit$greater$default$3() {
        return (WeightedQuantileSummaries.Stats[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(WeightedQuantileSummaries.Stats.class));
    }

    public double $lessinit$greater$default$4() {
        return 0.0;
    }

    public boolean $lessinit$greater$default$5() {
        return false;
    }

    public int defaultCompressThreshold() {
        return this.defaultCompressThreshold;
    }

    public int defaultBufferSize() {
        return this.defaultBufferSize;
    }

    public double defaultRelativeError() {
        return this.defaultRelativeError;
    }

    public WeightedQuantileSummaries.Stats[] sparklyr$WeightedQuantileSummaries$$compressImmut(WeightedQuantileSummaries.Stats[] currentSamples, double totalWeight, double mergeThreshold) {
        ListBuffer res;
        block4: {
            int i;
            if (currentSamples.length < 3) {
                return currentSamples;
            }
            res = (ListBuffer)ListBuffer$.MODULE$.empty();
            WeightedQuantileSummaries.Stats head = (WeightedQuantileSummaries.Stats)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])currentSamples)).last();
            double leftSum = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), i - 1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> currentSamples[j].s() + currentSamples[j].l(), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + currentSamples[i - 1].l();
            double rightSum = head.r();
            double leftIncrement = 0.0;
            double rightIncrement = 0.0;
            double headRightSum = rightSum;
            for (i = currentSamples.length - 2; i >= 1; --i) {
                double gap = totalWeight - headRightSum - leftSum;
                leftSum -= currentSamples[i - 1].l();
                if (i > 1) {
                    leftSum -= currentSamples[i - 2].s();
                }
                rightSum += currentSamples[i + 1].s() + currentSamples[i].r();
                if (gap >= mergeThreshold) {
                    WeightedQuantileSummaries.Stats qual$1 = head;
                    double x$1 = head.l() + leftIncrement;
                    double x$2 = qual$1.copy$default$1();
                    double x$3 = qual$1.copy$default$2();
                    double x$4 = qual$1.copy$default$4();
                    head = qual$1.copy(x$2, x$3, x$1, x$4);
                    WeightedQuantileSummaries.Stats qual$2 = currentSamples[i];
                    double x$5 = currentSamples[i].r() + rightIncrement;
                    double x$6 = qual$2.copy$default$1();
                    double x$7 = qual$2.copy$default$2();
                    double x$8 = qual$2.copy$default$3();
                    currentSamples[i] = qual$2.copy(x$6, x$7, x$8, x$5);
                    res.prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WeightedQuantileSummaries.Stats[]{head}));
                    head = currentSamples[i];
                    headRightSum = rightSum;
                    leftIncrement = 0.0;
                    rightIncrement = 0.0;
                    continue;
                }
                leftIncrement += currentSamples[i].l() + currentSamples[i].s();
                rightIncrement += currentSamples[i].r() + currentSamples[i].s();
            }
            res.prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WeightedQuantileSummaries.Stats[]{head}));
            if (currentSamples.length <= 1) break block4;
            res.prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WeightedQuantileSummaries.Stats[]{(WeightedQuantileSummaries.Stats)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])currentSamples)).head()}));
        }
        return (WeightedQuantileSummaries.Stats[])res.toArray(ClassTag$.MODULE$.apply(WeightedQuantileSummaries.Stats.class));
    }

    public double[][] approxWeightedQuantile(Dataset<Row> df, String[] cols, String weightCol, double[] probabilities, double relativeError) {
        Predef$.MODULE$.require(relativeError >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Relative Error must be non-negative but got ").append(relativeError).toString());
        String[] requiredCols = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cols)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{weightCol})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Seq colExprs = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredCols)).map((Function1 & Serializable & scala.Serializable)colName -> new Column(colName).cast((DataType)DoubleType$.MODULE$), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        WeightedQuantileSummaries[] emptySummaries = (WeightedQuantileSummaries[])Array$.MODULE$.fill(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cols)).size(), (Function0 & Serializable & scala.Serializable)() -> new WeightedQuantileSummaries(MODULE$.defaultCompressThreshold(), relativeError, MODULE$.$lessinit$greater$default$3(), MODULE$.$lessinit$greater$default$4(), MODULE$.$lessinit$greater$default$5()), ClassTag$.MODULE$.apply(WeightedQuantileSummaries.class));
        RDD qual$1 = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredCols)).map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).select(colExprs).rdd();
        WeightedQuantileSummaries[] x$1 = emptySummaries;
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(summaries, row) -> WeightedQuantileSummaries$.apply$1(summaries, row, weightCol);
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(sum1, sum2) -> WeightedQuantileSummaries$.merge$1(sum1, sum2);
        int x$4 = qual$1.treeAggregate$default$4((Object)x$1);
        WeightedQuantileSummaries[] summaries2 = (WeightedQuantileSummaries[])qual$1.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(WeightedQuantileSummaries.class)));
        return (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])summaries2)).map((Function1 & Serializable & scala.Serializable)summary -> (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(probabilities)).flatMap((Function1 & Serializable & scala.Serializable)quantile -> Option$.MODULE$.option2Iterable(summary.query(BoxesRunTime.unboxToDouble((Object)quantile))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final WeightedQuantileSummaries[] apply$1(WeightedQuantileSummaries[] summaries, Row row, String weightCol$1) {
        for (int i = 0; i < summaries.length; ++i) {
            double v;
            if (row.isNullAt(i) || Predef$.MODULE$.double2Double(v = row.getDouble(i)).isNaN()) continue;
            double w = row.getDouble(row.fieldIndex(weightCol$1));
            summaries[i] = summaries[i].insert(v, w);
        }
        return summaries;
    }

    private static final WeightedQuantileSummaries[] merge$1(WeightedQuantileSummaries[] sum1, WeightedQuantileSummaries[] sum2) {
        return (WeightedQuantileSummaries[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sum1)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sum2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            WeightedQuantileSummaries s1 = (WeightedQuantileSummaries)tuple2._1();
            WeightedQuantileSummaries s2 = (WeightedQuantileSummaries)tuple2._2();
            WeightedQuantileSummaries weightedQuantileSummaries = s1.compress().merge(s2.compress());
            return weightedQuantileSummaries;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WeightedQuantileSummaries.class)));
    }

    private WeightedQuantileSummaries$() {
        MODULE$ = this;
        this.defaultCompressThreshold = 10000;
        this.defaultBufferSize = 50000;
        this.defaultRelativeError = 0.01;
    }
}

