% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_all_functions.R
\docType{data}
\name{acoustic}
\alias{acoustic}
\title{Phonetics acoustic data (complete)}
\format{A data frame with 24830 rows and 11 variables}
\description{
The data are part of a large study on consonant assimilation, which is
the phenomenon that the articulation of two consonants becomes
phonetically more alike when they appear subsequently in fluent speech.
The data set contains the audio signals of nine different speakers which
repeated the same sixteen German target words each five times.
The target words are bisyllabic noun-noun compound words which
contained the two abutting consonants of interest,
s and sh, in either order. Consonant assimilation is accompanied by a complex interplay
of language-specific, perceptual and articulatory factors. The aim in the study was to investigate the assimilation
of the two consonants as a function of their order (either first s, then sh or vice-versa),
syllable stress (stressed or unstressed) and vowel
context, i.e. which vowels are immediately adjacent to the target consonants of interest.
The vowels are either of the form ia or ai. For more details, see references below.
}
\details{
The variables are as follows:

\itemize{
\item \code{subject_long}: unique identification number for each speaker.
\item \code{word_long}: unique identification number for each target word.
\item \code{combi_long}: number of the repetition of the combination of the
corresponding speaker and target word.
\item \code{y_vec}: the response values for each observation point
\item \code{n_long}: unique identification number for each curve.
\item \code{t}: the observations point locations.
\item \code{covariate.1}: (order of the consonants, reference category first /s/ then /sh/).
\item \code{covariate.2}: (stress of the final syllable of the first compound,
reference category 'stressed').
\item \code{covariate.3}: (stress of the initial syllable of the second compound,
reference category 'stressed').
\item \code{covariate.4}: (vowel context, reference category ia).
\item \code{word_names_long}: names of the target words.
}
}
\references{
Pouplier, Marianne and Hoole, Philip (2016): Articulatory and
Acoustic Characteristics of German Fricative Clusters,
Phonetica, 73(1), 52--78.

Cederbaum, Pouplier, Hoole, Greven (2016): Functional Linear Mixed Models
for Irregularly or Sparsely Sampled Data. Statistical Modelling, 16(1), 67-88.
}
\keyword{datasets}
