% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsegl-methods.R
\name{print.sparsegl}
\alias{print.sparsegl}
\title{Print a \code{sparsegl} object.}
\usage{
\method{print}{sparsegl}(x, digits = min(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{Fitted \code{\link[=sparsegl]{sparsegl()}} object.}

\item{digits}{Significant digits in printout.}

\item{...}{not used}
}
\description{
Prints some summary information about the fitted \code{\link[=sparsegl]{sparsegl()}} object.
}
\examples{
n <- 100
p <- 20
X <- matrix(rnorm(n * p), nrow = n)
eps <- rnorm(n)
beta_star <- c(rep(5, 5), c(5, -5, 2, 0, 0), rep(-5, 5), rep(0, (p - 15)))
y <- X \%*\% beta_star + eps
groups <- rep(1:(p / 5), each = 5)
fit1 <- sparsegl(X, y, group = groups)
print(fit1)
}
\seealso{
\code{\link[=sparsegl]{sparsegl()}}, \code{\link[=coef.sparsegl]{coef.sparsegl()}} and
\code{\link[=predict.sparsegl]{predict.sparsegl()}} methods.
}
