% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_sparta.R
\name{marg}
\alias{marg}
\alias{marg.sparta}
\title{Marginalization of sparse tables}
\usage{
marg(x, y, flow = "sum")

\method{marg}{sparta}(x, y, flow = "sum")
}
\arguments{
\item{x}{sparta object}

\item{y}{character vector of the variables to marginalize out}

\item{flow}{either "sum" or "max"}
}
\value{
A sparta object (or scalar if all variables are summed out)
}
\description{
Marginalize a sparse table given a vector of variables to marginalize out
}
\examples{

x <- array(
 c(1,0,0,2,3,4,0,0),
 dim = c(2,2,2),
 dimnames = list(
   a = c("a1", "a2"),
   b = c("b1", "b2"),
   c = c("c1", "c2")
 )
)

sx <- as_sparta(x)
marg(sx, c("c"))

su <- sparta_unity_struct(dim_names(sx), rank = 3.14)
marg(su, c("a", "b"))
}
