lhc_generateLHCSummary <-
function(FILEPATH,LHC_PARAM_CSV_LOCATION,PARAMETERS,NUMSAMPLES,MEASURES,MEDIANSFILEFORMAT,MEDIANSFILENAME,LHCSUMMARYFILENAME)
{
	if(file.exists(FILEPATH))
	{
		# LHCSUMMARYFILENAME IS LHCSummary.csv for 1 timepoint
		# READ IN THE LHC DESIGN TABLE - NEED TO REFER TO THIS LATER AS PARAMETERS ARE LISTED WITH THE MEDIAN RESULT SET
		if(file.exists(LHC_PARAM_CSV_LOCATION))
		{
			print("Generating LHC result summary file from median simulation results (lhc_generateLHCSummary)")

			LHCTABLE<-read.csv(LHC_PARAM_CSV_LOCATION,header=TRUE)
	
			# SUMMARY TABLE WILL STORE THE PARAMETERS USED IN THE RUN SET, AND THE MEDIAN OUTPUT MEASURES, FOR EACH SET	
			SUMMARYTABLE<-NULL	
	
			# NOW GO THROUGH EACH PARAMETER SUBSET GENERATED BY THE LHC
			for(j in 1:NUMSAMPLES)
			{
				# GET THE PARAMETERS USED FOR THIS SET OF RUNS
				PARAMROW<-NULL
				PARAMROW <- t(as.numeric(LHCTABLE[j,]))
		
				# STORE IN A NEW VECTOR, RESULTS WILL BE ADDED TO THIS
				SUMMARYOUTPUTROW<-NULL		
				
				# GET THE MEDIAN MODEL RESULTS
				MEDIANFILEPATH = paste(FILEPATH,"/",j,"/",MEDIANSFILENAME,sep="")
				
				if(file.exists(paste(MEDIANFILEPATH,".csv",sep="")) | file.exists(paste(MEDIANFILEPATH,".xml",sep="")))
				{
					if(MEDIANSFILEFORMAT=="csv")
					{
						MODELRESULT<-read.csv(paste(MEDIANFILEPATH,".csv",sep=""))
					}
					else if(MEDIANSFILEFORMAT=="xml")
					{
						# XML Median Set
						MODELRESULT<-xmlToDataFrame(paste(MEDIANFILEPATH,".xml",sep=""))
					}
		
					# NOW GET THE MEDIAN OF ALL RUNS PERFORMED FOR THIS SUBSET
					MEDIANSFORALLMEASURES<-NULL
		
					# NOW GET THE MEDIANS FOR EACH MEASURE
					for(l in 1:length(MEASURES))
					{
						MEASURE_RESULT<-as.matrix(MODELRESULT[MEASURES[l]])
						MEASUREMEDIAN<-median(as.numeric(MEASURE_RESULT))
						MEDIANSFORALLMEASURES<-cbind(MEDIANSFORALLMEASURES,MEASUREMEDIAN[[1]])
						
						#measureMedian <- median(modelResult[MEASURES[l]][,1])
						#mediansForAllMeasures<-cbind(mediansForAllMeasures,measureMedian)
					}
					SUMMARYOUTPUTROW<-cbind(PARAMROW,MEDIANSFORALLMEASURES)
					SUMMARYTABLE<-rbind(SUMMARYTABLE,SUMMARYOUTPUTROW)
				}
			}
	
			# WRITE OUT THE SUMMARY FILE
			if(!is.null(SUMMARYTABLE))
			{
				OUTPUTCOLHEADERS<-cbind(t(PARAMETERS),t(MEASURES))
				colnames(SUMMARYTABLE)<-OUTPUTCOLHEADERS
				SUMMARYRESULTSFILE<-paste(FILEPATH,"/",LHCSUMMARYFILENAME,".csv",sep="")
				write.csv(SUMMARYTABLE,SUMMARYRESULTSFILE,quote = FALSE,row.names=FALSE)

				print(paste("LHC Summary file output to ",SUMMARYRESULTSFILE,sep=""))
			}
		}
		else
		{
			print("LHC Parameter file does not exist. Check variable LHC_PARAM_CSV_LOCATION")
		}
	}
	else
	{
		print("The directory specified in FILEPATH does not exist. No analysis performed")
	}

	
}

