% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vunit_measure.R
\name{vunit_measure}
\alias{vunit_measure}
\alias{vunit_measure-spatPomp}
\alias{vunit_measure,spatPomp-method}
\title{vunit_measure}
\usage{
\S4method{vunit_measure}{spatPomp}(object, x, unit, time, params, Np = 1)
}
\arguments{
\item{object}{An object of class \code{spatPomp}}

\item{x}{A state vector for all units}

\item{unit}{The unit for which to evaluate the variance}

\item{time}{The time for which to evaluate the variance}

\item{params}{parameters at which to evaluate the unit variance}

\item{Np}{numeric; defaults to 1 and the user need not change this}
}
\value{
A matrix with the unit measurement variance implied by the state, \code{x},
and the parameter set \code{params} for unit \code{unit}.
}
\description{
\code{vunit_measure} evaluates the variance of a unit's observation given the entire state
}
\examples{
b <- bm(U=3)
s <- states(b)[,1,drop=FALSE]
rownames(s) -> rn
dim(s) <- c(3,1,1)
dimnames(s) <- list(variable=rn, rep=NULL)
p <- coef(b); names(p) -> rnp
dim(p) <- c(length(p),1); dimnames(p) <- list(param=rnp)
o <- obs(b)[,1,drop=FALSE]
vunit_measure(b, x=s, unit=2, time=1, params=p)
}
