% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igirf.R
\name{igirf}
\alias{igirf}
\alias{igirf-missing}
\alias{igirf,missing-method}
\alias{igirf-ANY}
\alias{igirf,ANY-method}
\alias{igirf-spatPomp}
\alias{igirf,spatPomp-method}
\alias{igirf-igirfd_spatPomp}
\alias{igirf,igirfd_spatPomp-method}
\title{Iterated guided intermediate resampling filter (IGIRF)}
\usage{
\S4method{igirf}{missing}(data, ...)

\S4method{igirf}{ANY}(data, ...)

\S4method{igirf}{spatPomp}(
  data,
  Ngirf,
  Np,
  rw.sd,
  cooling.type,
  cooling.fraction.50,
  Ninter,
  lookahead = 1,
  Nguide,
  kind = c("bootstrap", "moment"),
  tol = 1e-300,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{igirf}{igirfd_spatPomp}(
  data,
  Ngirf,
  Np,
  rw.sd,
  cooling.type,
  cooling.fraction.50,
  Ninter,
  lookahead,
  Nguide,
  kind = c("bootstrap", "moment"),
  tol,
  ...,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{data}{an object of class \code{spatPomp} or \code{igirfd_spatPomp}}

\item{...}{If a \code{params} argument is specified, \code{abf} will estimate the likelihood at that parameter set instead of at \code{coef(object)}.}

\item{Ngirf}{the number of iterations of parameter-perturbed GIRF.}

\item{Np}{The number of particles used within each replicate for the adapted simulations.}

\item{rw.sd}{specification of the magnitude of the random-walk perturbations that will be applied to some or all model parameters.
Parameters that are to be estimated should have positive perturbations specified here.
The specification is given using the \code{\link[pomp]{rw.sd}} function, which creates a list of unevaluated expressions.
The latter are evaluated in a context where the model time variable is defined (as \code{time}).
The expression \code{ivp(s)} can be used in this context as shorthand for \preformatted{ifelse(time==time[1],s,0).}
Likewise, \code{ivp(s,lag)} is equivalent to \preformatted{ifelse(time==time[lag],s,0).}
See below for some examples.

The perturbations that are applied are normally distributed with the specified s.d.
If parameter transformations have been supplied, then the perturbations are applied on the transformed (estimation) scale.}

\item{cooling.type, cooling.fraction.50}{specifications for the cooling schedule,
i.e., the manner and rate with which the intensity of the parameter perturbations is reduced with successive filtering iterations.
\code{cooling.type} specifies the nature of the cooling schedule.
See below (under \dQuote{Specifying the perturbations}) for more detail.}

\item{Ninter}{the number of intermediate resampling time points. By default, this is set equal to the number of units.}

\item{lookahead}{The number of future observations included in the guide function.}

\item{Nguide}{The number of simulations used to estimate state process uncertainty for each particle.}

\item{kind}{One of two types of guide function construction. Defaults to \code{'bootstrap'}. See Park and Ionides (2020) for more details.}

\item{tol}{If all of the guide function evaluations become too small (beyond floating-point precision limits), we set them to this value.}

\item{verbose}{logical; if \code{TRUE}, messages updating the user on progress will be printed to the console.}
}
\value{
Upon successful completion, \code{igirf()} returns an object of class
\sQuote{igirfd_spatPomp}. This object contains the convergence record of the iterative algorithm with
respect to the likelihood and the parameters of the model (which can be accessed using the \code{traces}
attribute) as well as a final parameter estimate, which can be accessed using the \code{coef()}. The
algorithmic parameters used to run \code{igirf()} are also included.
}
\description{
An implementation of a parameter estimation algorithm combining
the intermediate resampling scheme of the guided intermediate resampling filter of Park and Ionides (2020)
and the parameter perturbation scheme of Ionides et al. (2015) following the pseudocode in Asfaw, et al. (2020).
}
\section{Methods}{

The following methods are available for such an object:
\describe{
\item{\code{\link{coef}}}{ gives the Monte Carlo maximum likelihood parameter estimate. }
}
}

\examples{
# Complete examples are provided in the package tests
\dontrun{
igirf(bm(U=2,N=4),Ngirf=2,
  rw.sd = rw_sd(rho=0.02,X1_0=ivp(0.02)),
  cooling.type="geometric",cooling.fraction.50=0.5,
  Np=10,Ninter=2,lookahead=1,Nguide=5)
}
}
\references{
\park2020

\asfaw2020
}
\seealso{
likelihood evaluation algorithms: \code{girf()}, \code{enkf()}, \code{bpfilter()}, \code{abf()}, \code{abfir()}

Other likelihood maximization algorithms: 
\code{\link{ibpf}()},
\code{\link{ienkf}()},
\code{\link{iubf}()}
}
\author{
Kidus Asfaw
}
\concept{likelihood maximization algorithms}
