% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/land.metrics.R
\name{land.metrics}
\alias{land.metrics}
\title{Landscape metrics for points and polygons}
\usage{
land.metrics(x, y, bkgd = NA, metrics = c(4, 14, 33, 34, 35, 37, 38),
  bw = 1000, latlon = FALSE, trace = TRUE)
}
\arguments{
\item{x}{SpatalPointsDataFrame or SpatalPolgonsDataFrame class object}

\item{y}{raster class object}

\item{bkgd}{Background value (will be ignored)}

\item{metrics}{Numeric index of desired metric (see available metrics)}

\item{bw}{Buffer distance (ignored if x is SpatalPolgonsDataFrame)}

\item{latlon}{Is raster data in lat-long (TRUE/FALSE)}

\item{trace}{Plot raster subsets and echo object ID at each iteration (TRUE | FALSE)}
}
\value{
If multiple classes are evaluated a list object with a data.frame for each class contaning specified metrics in columns. The data.frame is ordered and shares the same row.names as the input feature class and can be directly joined to the @data slot. For single class problems a data.frame object is returned.
}
\description{
Calculates a variety of landscape metrics, on binary rasters, for polygons or points with a buffer distance
}
\note{
[2]n.patches, [3]total.area, [4]prop.landscape          
 [5]patch.density, [6]total.edge, [7]edge.density, [8]landscape.shape.index   
 [9]largest.patch.index, [10]mean.patch.area, [11]sd.patch.area, [12]min.patch.area          
 [13]max.patch.area, [14]perimeter.area.frac.dim, [15]mean.perim.area.ratio, [16]sd.perim.area.ratio     
 [17]min.perim.area.ratio, [18]max.perim.area.ratio, [19]mean.shape.index, [20]sd.shape.index          
 [21]min.shape.index, [22]max.shape.index, [23]mean.frac.dim.index, [24]sd.frac.dim.index       
 [25]min.frac.dim.index, [26]max.frac.dim.index, [27]total.core.area, [28]prop.landscape.core     
 [29]mean.patch.core.area, [30]sd.patch.core.area, [31]min.patch.core.area, [32]max.patch.core.area     
 [33]prop.like.adjacencies, [34]aggregation.index, [35]lanscape.division.index, [36]splitting.index         
 [37]effective.mesh.size, [38]patch.cohesion.index

Modifications to the function incorporate multi-class metrics by fetching the unique values of the raster and creating a list object contaning a data.frame for each class. Unfortunately, retrieving unique values is a very slow function.

depends: sp, raster, rgeos, SDMTools
}
\examples{
 library(raster)
 library(sp)

 r <- raster(nrows=180, ncols=360, xmn=571823.6, xmx=616763.6, ymn=4423540, 
             ymx=4453690, resolution=270, crs = CRS("+proj=utm +zone=12 +datum=NAD83 
             +units=m +no_defs +ellps=GRS80 +towgs84=0,0,0"))

 r[] <- rpois(ncell(r), lambda=1)
 r <- calc(r, fun=function(x) { x[x >= 1] <- 1; return(x) } )  
 x <- sampleRandom(r, 10, na.rm = TRUE, sp = TRUE)

 ( class.1 <- land.metrics(x=x, y=r, bw=1000, bkgd = 0, metrics = c(4,7,33,34)) )
 ( all.class <- land.metrics(x=x, y=r, bw=1000, bkgd = NA, metrics = c(4,7,33,34)) )

 # Pull metrics associated with class "0"
 all.class[["0"]]

}
\seealso{
\code{\link[SDMTools]{ConnCompLabel}}

\code{\link[SDMTools]{PatchStat}}

\code{\link[SDMTools]{ClassStat}}
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
