% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitpsd.R
\name{xmin_estim}
\alias{xmin_estim}
\title{Estimate the minimum patch size of a power-law distribution}
\usage{
xmin_estim(dat, bounds = range(dat))
}
\arguments{
\item{dat}{A vector of integer values}

\item{bounds}{A vector of two values representing the bounds in which 
the best xmin is searched}
}
\value{
The estimated xmin as an integer value
}
\description{
When fitting a power-law to a discrete distribution, it might 
  be worth discarding points below a certain threshold (xmin) to improve 
  the fit. This function estimates the optimal xmin based on the 
  Kolmogorov-Smirnoff distance between the fit and the empirical 
  distribution, as suggested by Clauset et al. (2009).
}
\details{
The function returns NA if \code{dat} has only three unique values 
  or if the power-law fit failed.
}
\examples{

\dontrun{ 
psd <- patchsizes(forestgap[[5]])
xmin_estim(psd)
}
}
\references{
Clauset, A., Shalizi, C. R., & Newman, M. E. (2009). 
  Power-law distributions in empirical data. SIAM review, 51(4), 661-703.
}
\seealso{
\code{\link{patchdistr_sews}}
}
