#
#  nearestsegment.R
#
#  $Revision: 1.4 $  $Date: 2009/04/03 20:29:22 $
#
# Given a point pattern X and a line segment pattern Y,
# for each point x of X, determine which segment of Y is closest to x
# and find the point on Y closest to x.
#

nearestsegment <- function(X,Y) {
  return(ppllengine(X,Y,"identify"))
}

project2segment <- function(X, Y) {
  return(ppllengine(X,Y,"project"))
}
  
ppllengine <- function(X, Y, action="project", check=FALSE) {
  stopifnot(is.ppp(X))
  stopifnot(is.psp(Y))
  stopifnot(action %in% c("distance", "identify", "project"))
  XX <- as.matrix(as.data.frame(unmark(X)))
  YY <- as.matrix(as.data.frame(unmark(Y)))
  # determine which segment lies closest to each point
  d <- distppllmin(XX, YY)
  mapXY <- d$min.which
  if(action == "identify")
    return(mapXY)
  else if(action == "distance") 
    return(data.frame(dist=d$min.d, which=mapXY))
  
  # combine relevant rows of data
  alldata <- as.data.frame(cbind(XX, YY[mapXY,]))
  colnames(alldata) <- c("x", "y", "x0", "y0", "x1", "y1")
  # coordinate geometry
  dx <- with(alldata, x1-x0)
  dy <- with(alldata, y1-y0)
  leng <- sqrt(dx^2 + dy^2)
  # rotation sines & cosines
  co <- dx/leng
  si <- dy/leng
  # vector to point from first endpoint of segment
  xv <- with(alldata, x - x0)
  yv <- with(alldata, y - y0)
  # rotate coordinate system so that x axis is parallel to line segment
  xpr <- xv * co + yv * si
  ypr <- - xv * si + yv * co
  # determine whether projection is an endpoint or interior point of segment
  left <- (xpr <= 0)
  right <- (xpr >= leng)
  # location of projected point in rotated coordinates
  xr <- with(alldata, ifelse(left, 0, ifelse(right, leng, xpr)))
  # back to standard coordinates
  xproj <- with(alldata, x0 + xr * co)
  yproj <- with(alldata, y0 + xr * si)
  Xproj <- ppp(xproj, yproj, window=X$window, marks=X$marks, check=check)
  # parametric coordinates
  tp <- xr/leng
  tp[!is.finite(tp)] <- 0
  # 
  return(list(Xproj=Xproj, mapXY=mapXY, d=d$min.d, tp=tp))
}

