% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatsurvMisc.R
\name{allocate}
\alias{allocate}
\title{allocate function}
\usage{
allocate(poly, popden, survdat, pid, sid, n = 2, wid = 2000)
}
\arguments{
\item{poly}{a SpatialPolygonsDataFrame, on which the survival data exist in aggregate form}

\item{popden}{a sub-polygon raster image of population density}

\item{survdat}{data.frame containing the survival data}

\item{pid}{name of the variable in the survival data that gives the region identifier in poly}

\item{sid}{the name of the variable in poly to match the region identifier in survdat to}

\item{n}{the number of different allocations to make. e.g. if n is 2 (the default) two candidate sets of locations are available.}

\item{wid}{The default is 2000, interpreted in metres ie 2Km. size of buffer to add to window for raster cropping purposes: this ensures that for each polygon, the cropped raster covers it completely.}
}
\value{
matrices x and y, both of size (number of observations in survdat x n) giving n potential candidate locations of points in the columns of x and y.
}
\description{
A function to allocate coordinates to an observation whose spatial location is known to the regional level
}

