% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROIplot.R
\name{ROIplot}
\alias{ROIplot}
\title{Plot NMR spectra, together with raw and grouped peaks}
\usage{
ROIplot(Y.spec, X.ppm, ungrouped.peaks, grouped.peaks, ROI = NULL,
  ROI.ppm = NULL, roiWidth = 100, roiWidth.ppm = NULL,
  groupLabels = NULL, output = NULL)
}
\arguments{
\item{Y.spec}{(required) The raw spectra in matrix format (1 sample per row) or numeric vector (in case of 1 spectrum)}

\item{X.ppm}{(required) The vector with the ppm values}

\item{ungrouped.peaks}{(required) The data resulting from peak detection with wavelets}

\item{grouped.peaks}{(required) The data after grouping (with PeakGrouper)}

\item{ROI}{If provided (with an index value, not a ppm value) only this region of interest will be plotted. (supply no ROI or ROI.ppm values, for the full spectrum, or specify only 1, either ROI or ROI.ppm).}

\item{ROI.ppm}{If provided (a ppm value, not an index value) only this region of interest will be plotted. (supply no ROI or ROI.ppm values, for the full spectrum, or specify only 1, either ROI or ROI.ppm).}

\item{roiWidth}{The width of the ROI (region of interest) plot in index points/measurement points. The plot will span from ROI/ROI.ppm - roiWidth to ROI/ROI.ppm + roiWidth. (only supply roiWidth or roiWidth.ppm if needed).}

\item{roiWidth.ppm}{The width of the ROI (region of interest) plot in ppm. The plot will span from ROI/ROI.ppm - roiWidth.ppm to ROI/ROI.ppm + roiWidth.ppm. (only supply roiWidth or roiWidth.ppm if needed).}

\item{groupLabels}{The vector with group labels (as factors)}

\item{output}{Whether to return a plot (default), or the individual ggplot objects (output = "ggObjects")}
}
\value{
a plot
}
\description{
This function plots NMR spectra, peak plots and grouped peak plots all in figure for easy comparison.
}
\examples{
subset <- GetWinedata.subset()
subset.spectra = as.matrix(subset$Spectra)
subset.ppm = as.numeric(subset$PPM)

test.peaks <- getWaveletPeaks(Y.spec=subset.spectra, 
                              X.ppm=subset.ppm,
                              nCPU = 1) # nCPU set to 2 for the vignette build

test.grouped <- PeakGrouper(Y.peaks = test.peaks)
                           
ROI.ppm <- 4.9
roiWidth.ppm <- 0.15

plots <- ROIplot(Y.spec = subset.spectra,
                 X.ppm =subset.ppm, 
                 ungrouped.peaks = test.peaks,
                 grouped.peaks = test.grouped ,
                 ROI.ppm = ROI.ppm,
                 roiWidth.ppm = roiWidth.ppm , 
                 output = "ggObjects"
                 )

}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
