% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specLOMB.R
\name{gLmb}
\alias{gLmb}
\title{generalized Lomb-Scargle estimation function}
\usage{
gLmb(f, dat, w, Y, hYY)
}
\arguments{
\item{f}{frequency}

\item{dat}{spatial vector including locations and values}

\item{w}{vector of weights}

\item{Y}{weighted sum of values}

\item{hYY}{weighted sum of squared values}
}
\description{
calculates the generalized Lomb-Scargle estimation after Zechmeister et al. (2009)
}
\details{
This method is based on the generalized approach

\eqn{y(t) = a*cos(w*t) + b*sin(w*t) + c}

which contains the floating average value \eqn{c} of the model function above.
The calculation is vectorized to enhance calculation
speed.
}
