% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters_and_setters.R
\name{meta}
\alias{meta}
\alias{meta.spectra}
\title{Get metadata}
\usage{
meta(x, label, sample, simplify = FALSE, quiet = TRUE)

\method{meta}{spectra}(x, label = NULL, sample = NULL, simplify = FALSE, quiet = TRUE)
}
\arguments{
\item{x}{spectra object}

\item{label}{metadata column index or label}

\item{sample}{sample index or name}

\item{simplify}{boolean. defaults to FALSE}

\item{quiet}{boolean. warn about non-existent metadata? defaults to TRUE}
}
\value{
data frame or vector
}
\description{
\code{meta} returns metadata of spectra
}
\section{Methods (by class)}{
\itemize{
\item \code{meta(spectra)}: get metadata

}}
\examples{
library(spectrolab)
spec = as_spectra(spec_matrix_example, name_idx = 1)
spec = normalize(spec)
meta(spec, "normalization_magnitude")
}
\author{
Jose Eduardo Meireles
}
