% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_spectra.R
\name{smooth.default}
\alias{smooth.default}
\title{Default smoothing function}
\usage{
\method{smooth}{default}(x, kind = c("3RS3R", "3RSS", "3RSR", "3R", "3", "S"),
  twiceit = FALSE, endrule = c("Tukey", "copy"), do.ends = FALSE)
}
\arguments{
\item{x}{a vector or time series}

\item{kind}{a character string indicating the kind of smoother required;
    defaults to \code{"3RS3R"}.}

\item{twiceit}{logical, indicating if the result should be \sQuote{twiced}.
    Twicing a smoother \eqn{S(y)} means \eqn{S(y) + S(y - S(y))}, i.e.,
    adding smoothed residuals to the smoothed values.  This decreases
    bias (increasing variance).}

\item{endrule}{a character string indicating the rule for smoothing at the
    boundary.  Either \code{"Tukey"} (default) or \code{"copy"}.}

\item{do.ends}{logical, indicating if the 3-splitting of ties should
    also happen at the boundaries (ends).  This is only used for
    \code{kind = "S"}.}
}
\value{
An object of class \code{"tukeysmooth"} (which has \code{print} and
  \code{summary} methods) and is a vector or time series containing the
  smoothed values with additional attributes.
}
\description{
Default smoothing function
}
\details{
\emph{\code{3}} is Tukey's short notation for running \code{\link{median}}s
  of length \bold{3},
  \cr
  \emph{\code{3R}} stands for \bold{R}epeated \emph{\code{3}} until
  convergence, and
  \cr
  \emph{\code{S}} for \bold{S}plitting of horizontal stretches of length 2 or 3.

  Hence, \emph{\code{3RS3R}} is a concatenation of \code{3R}, \code{S}
  and \code{3R}, \emph{\code{3RSS}} similarly,
  whereas \emph{\code{3RSR}} means first \code{3R}
  and then \code{(S and 3)} \bold{R}epeated until convergence -- which
  can be bad.
}
\references{
Tukey, J. W. (1977).
  \emph{Exploratory Data Analysis},
  Reading Massachusetts: Addison-Wesley.
}
\seealso{
\code{\link{runmed}} for running medians;
  \code{\link{lowess}} and \code{\link{loess}};
  \code{\link{supsmu}} and
  \code{\link{smooth.spline}}.
}
